from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('LogFile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLogFile");
  exportedObject.put("roleName", "WebSphereLogFile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.logfile.maximumbackupfiles", objid, "maximumBackupFiles","LogFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.logfile.maximumsize", objid, "maximumSize","LogFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.logfile.filepath", objid, "filePath","LogFile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LogFile');
  return result;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('LogFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("LogFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maximumBackupFiles", roleProperties.optString("websphere.logfile.maximumbackupfiles", None));
  Util.addIfNotNone(properties, "maximumSize", roleProperties.optString("websphere.logfile.maximumsize", None));
  Util.addIfNotNone(properties, "filePath", roleProperties.optString("websphere.logfile.filepath", None));
  print "Creating LogFile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("LogFile", parentid, properties, attName);
  Util.popPathElement('LogFile');

def update(objid,jsonobject):
  Util.pushPathElement('LogFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("LogFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.logfile.maximumbackupfiles", None), "maximumBackupFiles","LogFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.logfile.maximumsize", None), "maximumSize","LogFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.logfile.filepath", None), "filePath","LogFile");
  if len(atts) != 0:
    print "Modifying LogFile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "LogFile configuration up to date.";

  Util.popPathElement('LogFile');
