from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WorkAreaService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWorkAreaService");
  exportedObject.put("roleName", "WebSphereWorkAreaService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareaservice.maxreceivesize", objid, "maxReceiveSize","WorkAreaService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareaservice.enable", objid, "enable","WorkAreaService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareaservice.maxsendsize", objid, "maxSendSize","WorkAreaService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workareaservice.enablewebservicepropagation", objid, "enableWebServicePropagation","WorkAreaService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WorkAreaService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WorkAreaService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('WorkAreaService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkAreaService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maxReceiveSize", roleProperties.optString("websphere.workareaservice.maxreceivesize", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.workareaservice.enable", None));
  Util.addIfNotNone(properties, "maxSendSize", roleProperties.optString("websphere.workareaservice.maxsendsize", None));
  Util.addIfNotNone(properties, "enableWebServicePropagation", roleProperties.optString("websphere.workareaservice.enablewebservicepropagation", None));
  print "Creating WorkAreaService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WorkAreaService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WorkAreaService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('WorkAreaService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkAreaService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareaservice.maxreceivesize", None), "maxReceiveSize","WorkAreaService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareaservice.enable", None), "enable","WorkAreaService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareaservice.maxsendsize", None), "maxSendSize","WorkAreaService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workareaservice.enablewebservicepropagation", None), "enableWebServicePropagation","WorkAreaService");
  if len(atts) != 0:
    print "Modifying WorkAreaService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WorkAreaService configuration up to date.";

  Property.removeProperties(objid, 'properties',"WorkAreaService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WorkAreaService');
