from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AuthModule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuthModule");
  exportedObject.put("roleName", "WebSphereAuthModule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authmodule.responsepolicy", objid, "responsePolicy","AuthModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authmodule.order", objid, "order","AuthModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authmodule.moduleid", objid, "moduleID","AuthModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authmodule.classname", objid, "className","AuthModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authmodule.requestpolicy", objid, "requestPolicy","AuthModule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"AuthModule");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuthModule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AuthModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "responsePolicy", roleProperties.optString("websphere.authmodule.responsepolicy", None));
  Util.addIfNotNone(properties, "order", roleProperties.optString("websphere.authmodule.order", None));
  Util.addIfNotNone(properties, "moduleID", roleProperties.optString("websphere.authmodule.moduleid", None));
  Util.addIfNotNone(properties, "className", roleProperties.optString("websphere.authmodule.classname", None));
  Util.addIfNotNone(properties, "requestPolicy", roleProperties.optString("websphere.authmodule.requestpolicy", None));
  print "Creating AuthModule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AuthModule", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('AuthModule');


def update(objid,jsonobject):
  Util.pushPathElement('AuthModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authmodule.responsepolicy", None), "responsePolicy","AuthModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authmodule.order", None), "order","AuthModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authmodule.moduleid", None), "moduleID","AuthModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authmodule.classname", None), "className","AuthModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authmodule.requestpolicy", None), "requestPolicy","AuthModule");
  if len(atts) != 0:
    print "Modifying AuthModule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AuthModule configuration up to date.";

  Property.removeProperties(objid, 'properties',"AuthModule");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('AuthModule');
