from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.deployedmiddlewareappedition.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'DeployedMiddlewareAppEdition');

  containmentpath = "%(parentconpath)sDeployedMiddlewareAppEdition:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('DeployedMiddlewareAppEdition')

  name = Util.getRequiredAttribute(objid, "name", 'DeployedMiddlewareAppEdition');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDeployedMiddlewareAppEdition");
  exportedObject.put("roleName", "WebSphereDeployedMiddlewareAppEdition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.deployedmiddlewareappedition.name", objid, "name","DeployedMiddlewareAppEdition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DeployedMiddlewareAppEdition");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DeployedMiddlewareAppEdition');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("DeployedMiddlewareAppEdition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.deployedmiddlewareappedition.name"):
    raise Exception("Resource role properties does not contain websphere.deployedmiddlewareappedition.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create DeployedMiddlewareAppEdition on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('DeployedMiddlewareAppEdition')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeployedMiddlewareAppEdition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.deployedmiddlewareappedition.name"):
    raise Exception("Resource role properties does not contain websphere.deployedmiddlewareappedition.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.deployedmiddlewareappedition.name", None));
  print "Creating DeployedMiddlewareAppEdition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DeployedMiddlewareAppEdition", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DeployedMiddlewareAppEdition');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('DeployedMiddlewareAppEdition')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeployedMiddlewareAppEdition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.deployedmiddlewareappedition.name"):
    raise Exception("Resource role properties does not contain websphere.deployedmiddlewareappedition.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.deployedmiddlewareappedition.name", None), "name","DeployedMiddlewareAppEdition");
  if len(atts) != 0:
    print "Modifying DeployedMiddlewareAppEdition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DeployedMiddlewareAppEdition configuration up to date.";

  Property.removeProperties(objid, 'properties',"DeployedMiddlewareAppEdition");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('DeployedMiddlewareAppEdition');
