from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from File import File

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EJBJarFile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEJBJarFile");
  exportedObject.put("roleName", "WebSphereEJBJarFile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbjarfile.lastmodified", objid, "lastModified","EJBJarFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbjarfile.originaluri", objid, "originalURI","EJBJarFile");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.ejbjarfile.types", objid, "types","EJBJarFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbjarfile.directoryentry", objid, "directoryEntry","EJBJarFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbjarfile.uri", objid, "URI","EJBJarFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbjarfile.size", objid, "size","EJBJarFile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = File.exportFiles(objid, respath, extraObjects, typeFolders, 'files', "EJBJarFile");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EJBJarFile');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('EJBJarFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBJarFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "lastModified", roleProperties.optString("websphere.ejbjarfile.lastmodified", None));
  Util.addIfNotNone(properties, "originalURI", roleProperties.optString("websphere.ejbjarfile.originaluri", None));
  Util.addPathProperty(properties, "types", roleProperties.optString("websphere.ejbjarfile.types", None));
  Util.addIfNotNone(properties, "directoryEntry", roleProperties.optString("websphere.ejbjarfile.directoryentry", None));
  Util.addIfNotNone(properties, "URI", roleProperties.optString("websphere.ejbjarfile.uri", None));
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.ejbjarfile.size", None));
  print "Creating EJBJarFile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EJBJarFile", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EJBJarFile');

def update(objid,jsonobject):
  Util.pushPathElement('EJBJarFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBJarFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbjarfile.lastmodified", None), "lastModified","EJBJarFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbjarfile.originaluri", None), "originalURI","EJBJarFile");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbjarfile.types", None), "types","EJBJarFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbjarfile.directoryentry", None), "directoryEntry","EJBJarFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbjarfile.uri", None), "URI","EJBJarFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbjarfile.size", None), "size","EJBJarFile");
  if len(atts) != 0:
    print "Modifying EJBJarFile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EJBJarFile configuration up to date.";

  File.removeFiles(objid, 'files',"EJBJarFile");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EJBJarFile');
