from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from FRCACacheGroupMember import FRCACacheGroupMember
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ExternalCacheGroupMember')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereExternalCacheGroupMember");
  exportedObject.put("roleName", "WebSphereExternalCacheGroupMember");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externalcachegroupmember.address", objid, "address","ExternalCacheGroupMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externalcachegroupmember.adapterbeanname", objid, "adapterBeanName","ExternalCacheGroupMember");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  frcaCacheGroupMember = Util.getOptionalAttribute(objid, 'frcaCacheGroupMember', 'ExternalCacheGroupMember');
  if frcaCacheGroupMember is not None and len(frcaCacheGroupMember) > 0:
    returndict = Util.createTypeFolder(respath, "FRCACacheGroupMember", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, FRCACacheGroupMember._export(frcaCacheGroupMember, currespath, 'FRCACacheGroupMember'));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ExternalCacheGroupMember');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ExternalCacheGroupMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExternalCacheGroupMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "address", roleProperties.optString("websphere.externalcachegroupmember.address", None));
  Util.addIfNotNone(properties, "adapterBeanName", roleProperties.optString("websphere.externalcachegroupmember.adapterbeanname", None));
  print "Creating ExternalCacheGroupMember with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ExternalCacheGroupMember", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereFRCACacheGroupMember":
        FRCACacheGroupMember.create(objid, curjsonobject);
  Util.popPathElement('ExternalCacheGroupMember');

def update(objid,jsonobject):
  Util.pushPathElement('ExternalCacheGroupMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExternalCacheGroupMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externalcachegroupmember.address", None), "address","ExternalCacheGroupMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externalcachegroupmember.adapterbeanname", None), "adapterBeanName","ExternalCacheGroupMember");
  if len(atts) != 0:
    print "Modifying ExternalCacheGroupMember with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ExternalCacheGroupMember configuration up to date.";

  frcaCacheGroupMember = Util.getOptionalAttribute(objid, 'frcaCacheGroupMember', 'ExternalCacheGroupMember');
  if frcaCacheGroupMember is not None and len(frcaCacheGroupMember) > 0:
    Util.remove(frcaCacheGroupMember);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereFRCACacheGroupMember":
        FRCACacheGroupMember.create(objid, curjsonobject);
  Util.popPathElement('ExternalCacheGroupMember');
