from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GenericChannelFactory')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGenericChannelFactory");
  exportedObject.put("roleName", "WebSphereGenericChannelFactory");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericchannelfactory.typeid", objid, "typeID","GenericChannelFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericchannelfactory.configuri", objid, "configURI","GenericChannelFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericchannelfactory.jarfile", objid, "jarFile","GenericChannelFactory");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"GenericChannelFactory");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GenericChannelFactory');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GenericChannelFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericChannelFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "typeID", roleProperties.optString("websphere.genericchannelfactory.typeid", None));
  Util.addIfNotNone(properties, "configURI", roleProperties.optString("websphere.genericchannelfactory.configuri", None));
  Util.addIfNotNone(properties, "jarFile", roleProperties.optString("websphere.genericchannelfactory.jarfile", None));
  print "Creating GenericChannelFactory with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GenericChannelFactory", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('GenericChannelFactory');

def update(objid,jsonobject):
  Util.pushPathElement('GenericChannelFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericChannelFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericchannelfactory.typeid", None), "typeID","GenericChannelFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericchannelfactory.configuri", None), "configURI","GenericChannelFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericchannelfactory.jarfile", None), "jarFile","GenericChannelFactory");
  if len(atts) != 0:
    print "Modifying GenericChannelFactory with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GenericChannelFactory configuration up to date.";

  Property.removeProperties(objid, 'properties',"GenericChannelFactory");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('GenericChannelFactory');
