from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from StateManageable import StateManageable

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ManagedObject')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereManagedObject");
  exportedObject.put("roleName", "WebSphereManagedObject");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.managedobject.name", objid, "name","ManagedObject");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"ManagedObject");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));    
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ManagedObject');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ManagedObject')
  if not jsonobject.has("roleProperties"):
    raise Exception("ManagedObject resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.managedobject.name", None));
  print "Creating ManagedObject with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ManagedObject", parentid, properties);
  
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"ManagedObject");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);    
    
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereStateManageable":
        StateManageable.create(objid, curjsonobject);
  Util.popPathElement('ManagedObject');
  
  
  

def update(objid,jsonobject):
  Util.pushPathElement('ManagedObject')
  if not jsonobject.has("roleProperties"):
    raise Exception("ManagedObject resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.managedobject.name", None), "name","ManagedObject");
  if len(atts) != 0:
    print "Modifying ManagedObject with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ManagedObject configuration up to date.";
    
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"ManagedObject");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);    
    
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereStateManageable":
        StateManageable.create(objid, curjsonobject);    

  Util.popPathElement('ManagedObject');
