from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from RoutingRule import RoutingRule
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RoutingPolicy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRoutingPolicy");
  exportedObject.put("roleName", "WebSphereRoutingPolicy");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  routingRules = Util.parseConfigIdListAttribute(objid, 'routingRules',"RoutingPolicy");
  for routingRule in routingRules:
    if len(routingRule) > 0:
      returndict = Util.createTypeFolder(respath, "RoutingRule", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      routingRuleName = Util.getOptionalAttribute(routingRule, "name", "RoutingRule");
      if routingRuleName == None or len(routingRuleName) == 0:
        routingRuleName = ("Routing Rule%s" % i)
      Util.addAllFromExport(extraObjects, RoutingRule._export(routingRule, currespath, routingRuleName));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RoutingPolicy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('RoutingPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("RoutingPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating RoutingPolicy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("RoutingPolicy", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereRoutingRule":
        RoutingRule.create(objid, curjsonobject);
  Util.popPathElement('RoutingPolicy');

def update(objid,jsonobject):
  Util.pushPathElement('RoutingPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("RoutingPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying RoutingPolicy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "RoutingPolicy configuration up to date.";

  routingRules = Util.parseConfigIdListAttribute(objid, 'routingRules', "RoutingPolicy");
  for routingRule in routingRules:
    if len(routingRule) > 0:
      Util.remove(routingRule);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereRoutingRule":
        RoutingRule.create(objid, curjsonobject);

  Util.popPathElement('RoutingPolicy');
