from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SARServerTarget')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSARServerTarget");
  exportedObject.put("roleName", "WebSphereSARServerTarget");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sarservertarget.name", objid, "name","SARServerTarget");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sarservertarget.nodename", objid, "nodeName","SARServerTarget");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SARServerTarget");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SARServerTarget');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SARServerTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("SARServerTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sarservertarget.name", None));
  Util.addIfNotNone(properties, "nodeName", roleProperties.optString("websphere.sarservertarget.nodename", None));
  print "Creating SARServerTarget with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SARServerTarget", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SARServerTarget');

def update(objid,jsonobject):
  Util.pushPathElement('SARServerTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("SARServerTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sarservertarget.name", None), "name","SARServerTarget");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sarservertarget.nodename", None), "nodeName","SARServerTarget");
  if len(atts) != 0:
    print "Modifying SARServerTarget with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SARServerTarget configuration up to date.";

  Property.removeProperties(objid, 'properties',"SARServerTarget");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SARServerTarget');
