from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBAuthGroupRef import SIBAuthGroupRef;
from SIBAuthUserRef import SIBAuthUserRef;

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthSender')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthSender");
  exportedObject.put("roleName", "WebSphereSIBAuthSender");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthSender');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthSender')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthSender resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating SIBAuthSender with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthSender", parentid, properties);

  typeFolders = {};

  i = 0;
  groups = Util.parseConfigIdListAttribute(objid, 'group', 'SIBAuthSender');
  for group in groups:
    if len(group) > 0:
      returndict = Util.createTypeFolder(respath, "SIBAuthGroupRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBAuthGroupRef._export(group, currespath, "SIBAuthGroupRef%s" % i));
      i = i + 1;

  i = 0;
  users = Util.parseConfigIdListAttribute(objid, 'user', 'SIBAuthSender');
  for user in users:
    if len(user) > 0:
      returndict = Util.createTypeFolder(respath, "SIBAuthUserRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBAuthUserRef._export(user, currespath, "SIBAuthUserRef%s" % i));
      i = i + 1;

  Util.popPathElement('SIBAuthSender');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthSender')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthSender resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying SIBAuthSender with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthSender configuration up to date.";

  Util.unsetAttribute(objid, "group", "SIBAuthSender");
  Util.unsetAttribute(objid, "user", "SIBAuthSender");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthGroupRef":
        SIBAuthGroupRef.create(objid, curjsonobject, 'group');
      elif currole == "WebSphereSIBAuthUserRef":
        SIBAuthUserRef.create(objid, curjsonobject, 'user');

  Util.popPathElement('SIBAuthSender');
