from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBMQLinkSenderChannelLocalizationPointRef import SIBMQLinkSenderChannelLocalizationPointRef
from WASConfLog import Log

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMQLinkSenderChannel')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMQLinkSenderChannel");
  exportedObject.put("roleName", "WebSphereSIBMQLinkSenderChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannel.shortretryinterval", objid, "shortRetryInterval","SIBMQLinkSenderChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannel.senderchannelname", objid, "senderChannelName","SIBMQLinkSenderChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannel.hostname", objid, "hostName","SIBMQLinkSenderChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannel.protocolname", objid, "protocolName","SIBMQLinkSenderChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannel.port", objid, "port","SIBMQLinkSenderChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannel.longretrycount", objid, "longRetryCount","SIBMQLinkSenderChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannel.longretryinterval", objid, "longRetryInterval","SIBMQLinkSenderChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannel.shortretrycount", objid, "shortRetryCount","SIBMQLinkSenderChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannel.senderchannelinitialstate", objid, "senderChannelInitialState","SIBMQLinkSenderChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannel.connamelist", objid, "connameList","SIBMQLinkSenderChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqlinksenderchannel.discinterval", objid, "discInterval","SIBMQLinkSenderChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  sendStream = Util.getOptionalAttribute(objid, 'sendStream', 'SIBMQLinkSenderChannel');
  if sendStream is not None and len(sendStream) > 0:
    returndict = Util.createTypeFolder(respath, "SIBMQLinkSenderChannelLocalizationPointRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBMQLinkSenderChannelLocalizationPointRef._export(sendStream, currespath, "SIBMQLinkSenderChannelLocalizationPoint"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMQLinkSenderChannel');
  return result;



def create(parentid, jsonobject, sibmessagingengineconpath):
  Util.pushPathElement('SIBMQLinkSenderChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQLinkSenderChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "shortRetryInterval", roleProperties.optString("websphere.sibmqlinksenderchannel.shortretryinterval", None));
  Util.addIfNotNone(properties, "senderChannelName", roleProperties.optString("websphere.sibmqlinksenderchannel.senderchannelname", None));
  Util.addIfNotNone(properties, "hostName", roleProperties.optString("websphere.sibmqlinksenderchannel.hostname", None));
  Util.addIfNotNone(properties, "protocolName", roleProperties.optString("websphere.sibmqlinksenderchannel.protocolname", None));
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.sibmqlinksenderchannel.port", None));
  Util.addIfNotNone(properties, "longRetryCount", roleProperties.optString("websphere.sibmqlinksenderchannel.longretrycount", None));
  Util.addIfNotNone(properties, "longRetryInterval", roleProperties.optString("websphere.sibmqlinksenderchannel.longretryinterval", None));
  Util.addIfNotNone(properties, "shortRetryCount", roleProperties.optString("websphere.sibmqlinksenderchannel.shortretrycount", None));
  Util.addIfNotNone(properties, "senderChannelInitialState", roleProperties.optString("websphere.sibmqlinksenderchannel.senderchannelinitialstate", None));
  # we don't want to give a default value if the connamelist attribute is missing (WI 54390)
  if roleProperties.has("websphere.sibmqlinksenderchannel.connamelist"):
    Util.addIfNotNone(properties, "connameList", roleProperties.optString("websphere.sibmqlinksenderchannel.connamelist", ""));
  Util.addIfNotNone(properties, "discInterval", roleProperties.optString("websphere.sibmqlinksenderchannel.discinterval", None));
  print "Creating SIBMQLinkSenderChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMQLinkSenderChannel", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBMQLinkSenderChannelLocalizationPointRef":
        SIBMQLinkSenderChannelLocalizationPointRef.create(objid, curjsonobject, "sendStream", sibmessagingengineconpath);
  Util.popPathElement('SIBMQLinkSenderChannel');

def update(objid, jsonobject, sibmessagingengineconpath):
  Util.pushPathElement('SIBMQLinkSenderChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQLinkSenderChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannel.shortretryinterval", None), "shortRetryInterval","SIBMQLinkSenderChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannel.senderchannelname", None), "senderChannelName","SIBMQLinkSenderChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannel.hostname", None), "hostName","SIBMQLinkSenderChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannel.protocolname", None), "protocolName","SIBMQLinkSenderChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannel.port", None), "port","SIBMQLinkSenderChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannel.longretrycount", None), "longRetryCount","SIBMQLinkSenderChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannel.longretryinterval", None), "longRetryInterval","SIBMQLinkSenderChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannel.shortretrycount", None), "shortRetryCount","SIBMQLinkSenderChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannel.senderchannelinitialstate", None), "senderChannelInitialState","SIBMQLinkSenderChannel");
  # we don't want to give a default value if the connamelist attribute is missing (WI 54390)
  if roleProperties.has("websphere.sibmqlinksenderchannel.connamelist"):
    Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannel.connamelist", ""), "connameList","SIBMQLinkSenderChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqlinksenderchannel.discinterval", None), "discInterval","SIBMQLinkSenderChannel");
  if len(atts) != 0:
    print "Modifying SIBMQLinkSenderChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMQLinkSenderChannel configuration up to date.";

  #unset sendStream. we will expect a subresource to handle this if necessary.
  Util.unsetAttribute(objid, "sendStream", "SIBMQLinkSenderChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBMQLinkSenderChannelLocalizationPointRef":
        SIBMQLinkSenderChannelLocalizationPointRef.create(objid, curjsonobject, "sendStream", sibmessagingengineconpath);
  Util.popPathElement('SIBMQLinkSenderChannel');
