from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMQServer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMQServer");
  exportedObject.put("roleName", "WebSphereSIBMQServer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.uuid", objid, "uuid","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.servername", objid, "serverName","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.name", objid, "name","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.enableautoresourcediscovery", objid, "enableAutoResourceDiscovery","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.port", objid, "port","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.discoveryauthalias", objid, "discoveryAuthAlias","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.trustmessageuseridentifiers", objid, "trustMessageUserIdentifiers","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.channel", objid, "channel","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.type", objid, "type","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.messagingauthalias", objid, "messagingAuthAlias","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.description", objid, "description","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.enablebindingstransportmode", objid, "enableBindingsTransportMode","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.discoveryreplytoqueue", objid, "discoveryReplyToQueue","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.host", objid, "host","SIBMQServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserver.transportchainname", objid, "transportChainName","SIBMQServer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMQServer');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMQServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibmqserver.uuid", None));
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.sibmqserver.servername", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibmqserver.name", None));
  Util.addIfNotNone(properties, "enableAutoResourceDiscovery", roleProperties.optString("websphere.sibmqserver.enableautoresourcediscovery", None));
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.sibmqserver.port", None));
  Util.addIfNotNone(properties, "discoveryAuthAlias", roleProperties.optString("websphere.sibmqserver.discoveryauthalias", None));
  Util.addIfNotNone(properties, "trustMessageUserIdentifiers", roleProperties.optString("websphere.sibmqserver.trustmessageuseridentifiers", None));
  Util.addIfNotNone(properties, "channel", roleProperties.optString("websphere.sibmqserver.channel", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.sibmqserver.type", None));
  Util.addIfNotNone(properties, "messagingAuthAlias", roleProperties.optString("websphere.sibmqserver.messagingauthalias", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibmqserver.description", None));
  Util.addIfNotNone(properties, "enableBindingsTransportMode", roleProperties.optString("websphere.sibmqserver.enablebindingstransportmode", None));
  Util.addIfNotNone(properties, "discoveryReplyToQueue", roleProperties.optString("websphere.sibmqserver.discoveryreplytoqueue", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.sibmqserver.host", None));
  Util.addIfNotNone(properties, "transportChainName", roleProperties.optString("websphere.sibmqserver.transportchainname", None));
  print "Creating SIBMQServer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMQServer", parentid, properties);
  Util.popPathElement('SIBMQServer');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMQServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.uuid", None), "uuid","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.servername", None), "serverName","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.name", None), "name","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.enableautoresourcediscovery", None), "enableAutoResourceDiscovery","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.port", None), "port","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.discoveryauthalias", None), "discoveryAuthAlias","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.trustmessageuseridentifiers", None), "trustMessageUserIdentifiers","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.channel", None), "channel","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.type", None), "type","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.messagingauthalias", None), "messagingAuthAlias","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.description", None), "description","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.enablebindingstransportmode", None), "enableBindingsTransportMode","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.discoveryreplytoqueue", None), "discoveryReplyToQueue","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.host", None), "host","SIBMQServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserver.transportchainname", None), "transportChainName","SIBMQServer");
  if len(atts) != 0:
    print "Modifying SIBMQServer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMQServer configuration up to date.";

  Util.popPathElement('SIBMQServer');
