from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSSecurityResponseGeneratorBindingConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSSecurityResponseGeneratorBindingConfig");
  exportedObject.put("roleName", "WebSphereSIBWSSecurityResponseGeneratorBindingConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwssecurityresponsegeneratorbindingconfig.name", objid, "name","SIBWSSecurityResponseGeneratorBindingConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSSecurityResponseGeneratorBindingConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSSecurityResponseGeneratorBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityResponseGeneratorBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwssecurityresponsegeneratorbindingconfig.name", None));
  print "Creating SIBWSSecurityResponseGeneratorBindingConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSSecurityResponseGeneratorBindingConfig", parentid, properties);
  Util.popPathElement('SIBWSSecurityResponseGeneratorBindingConfig');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSSecurityResponseGeneratorBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSSecurityResponseGeneratorBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwssecurityresponsegeneratorbindingconfig.name", None), "name","SIBWSSecurityResponseGeneratorBindingConfig");
  if len(atts) != 0:
    print "Modifying SIBWSSecurityResponseGeneratorBindingConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSSecurityResponseGeneratorBindingConfig configuration up to date.";

  Util.popPathElement('SIBWSSecurityResponseGeneratorBindingConfig');
