from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ContentMapping import ContentMapping

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('StaticFileServingPolicy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereStaticFileServingPolicy");
  exportedObject.put("roleName", "WebSphereStaticFileServingPolicy");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.staticfileservingpolicy.staticfiledocumentroot", objid, "staticFileDocumentRoot","StaticFileServingPolicy");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  contentMappings = Util.parseConfigIdListAttribute(objid, 'contentMappings',"StaticFileServingPolicy");
  for contentMapping in contentMappings:
    if len(contentMapping) > 0:
      returndict = Util.createTypeFolder(respath, "ContentMapping", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ContentMapping._export(contentMapping, currespath, "Content Mapping%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('StaticFileServingPolicy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('StaticFileServingPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("StaticFileServingPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "staticFileDocumentRoot", roleProperties.optString("websphere.staticfileservingpolicy.staticfiledocumentroot", None));
  print "Creating StaticFileServingPolicy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("StaticFileServingPolicy", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereContentMapping":
        ContentMapping.create(objid, curjsonobject);
  Util.popPathElement('StaticFileServingPolicy');

def update(objid,jsonobject):
  Util.pushPathElement('StaticFileServingPolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("StaticFileServingPolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.staticfileservingpolicy.staticfiledocumentroot", None), "staticFileDocumentRoot","StaticFileServingPolicy");
  if len(atts) != 0:
    print "Modifying StaticFileServingPolicy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "StaticFileServingPolicy configuration up to date.";

  contentMappings = Util.parseConfigIdListAttribute(objid, 'contentMappings', "StaticFileServingPolicy");
  for contentMapping in contentMappings:
    if len(contentMapping) > 0:
      Util.remove(contentMapping);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereContentMapping":
        ContentMapping.create(objid, curjsonobject);

  Util.popPathElement('StaticFileServingPolicy');
