from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  name = "StatisticsProvider";

  containmentpath = "%(parentconpath)sStatisticsProvider:/" % {'parentconpath':parentcontainmentpath}
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('StatisticsProvider')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereStatisticsProvider");
  exportedObject.put("roleName", "WebSphereStatisticsProvider");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.statisticsprovider.specification", objid, "specification","StatisticsProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('StatisticsProvider');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("StatisticsProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create StatisticsProvider on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;

def create(parentid, jsonobject):
  Util.pushPathElement('StatisticsProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("StatisticsProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "specification", roleProperties.optString("websphere.statisticsprovider.specification", None));
  print "Creating StatisticsProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("StatisticsProvider", parentid, properties);
  Util.popPathElement('StatisticsProvider');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('StatisticsProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("StatisticsProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.statisticsprovider.specification", None), "specification","StatisticsProvider");
  if len(atts) != 0:
    print "Modifying StatisticsProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "StatisticsProvider configuration up to date.";

  Util.popPathElement('StatisticsProvider');
