from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from EndPoint import EndPoint
from OverlayEndpoint import OverlayEndpoint
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Transport')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTransport");
  exportedObject.put("roleName", "WebSphereTransport");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transport.sslenabled", objid, "sslEnabled","Transport");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transport.sslconfig", objid, "sslConfig","Transport");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transport.external", objid, "external","Transport");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"Transport");

  address = Util.getOptionalAttribute(objid, 'address', 'Transport');
  if address is not None and len(address) > 0:
    if address.find("#EndPoint_") != -1:
      returndict = Util.createTypeFolder(respath, "EndPoint", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, EndPoint._export(address, currespath, 'address'));
    elif address.find("#OverlayEndpoint_") != -1:
      returndict = Util.createTypeFolder(respath, "OverlayEndpoint", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, OverlayEndpoint._export(address, currespath, 'address'));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Transport');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Transport')
  if not jsonobject.has("roleProperties"):
    raise Exception("Transport resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "sslEnabled", roleProperties.optString("websphere.transport.sslenabled", None));
  Util.addIfNotNone(properties, "sslConfig", roleProperties.optString("websphere.transport.sslconfig", None));
  Util.addIfNotNone(properties, "external", roleProperties.optString("websphere.transport.external", None));
  print "Creating Transport with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Transport", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereEndPoint":
          EndPoint.create(objid, curjsonobject, 'address');
        elif currole == "WebSphereOverlayEndpoint":
          OverlayEndpoint.create(objid, curjsonobject, 'address');
  Util.popPathElement('Transport');

def update(objid,jsonobject):
  Util.pushPathElement('Transport')
  if not jsonobject.has("roleProperties"):
    raise Exception("Transport resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transport.sslenabled", None), "sslEnabled","Transport");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transport.sslconfig", None), "sslConfig","Transport");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transport.external", None), "external","Transport");
  if len(atts) != 0:
    print "Modifying Transport with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Transport configuration up to date.";

  Property.removeProperties(objid, 'properties',"Transport");

  address = Util.getOptionalAttribute(objid, 'address', 'Transport');
  if address is not None and len(address) > 0:
    Util.remove(address);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereEndPoint":
          EndPoint.create(objid, curjsonobject, 'address');
        elif currole == "WebSphereOverlayEndpoint":
          OverlayEndpoint.create(objid, curjsonobject, 'address');
  Util.popPathElement('Transport');
