from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from AccessPointGroupRef import AccessPointGroupRef
from BridgeInterface import BridgeInterface;
from utilities import Util
from Property import Property

__name_att__ = "websphere.coregroupaccesspoint.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'CoreGroupAccessPoint');

  containmentpath = "%(parentconpath)sCoreGroupAccessPoint:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('CoreGroupAccessPoint')

  name = Util.getRequiredAttribute(objid, "name", 'CoreGroupAccessPoint');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCoreGroupAccessPoint");
  exportedObject.put("roleName", "WebSphereCoreGroupAccessPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.coregroupaccesspoint.name", objid, "name","CoreGroupAccessPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.coregroupaccesspoint.coregroup", objid, "coreGroup","CoreGroupAccessPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"CoreGroupAccessPoint");
  i = 0;
  interfaces = Util.parseConfigIdListAttribute(objid, 'bridgeInterfaces', "CoreGroupAccessPoint");
  for interface in interfaces:
    if len(interface) > 0:
      returndict = Util.createTypeFolder(respath, "BridgeInterface", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, BridgeInterface._export(interface, currespath, "BridgeInterface%s" % i));
      i = i + 1;

  apgrefs = Util.parseConfigIdListAttribute(objid, 'AccessPointGroup', 'CoreGroupAccessPoint');
  for apgref in apgrefs:
    if apgref is not None and len(apgref) > 0:
      returndict = Util.createTypeFolder(respath, "AccessPointGroupRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, AccessPointGroupRef._export(apgref, currespath));
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CoreGroupAccessPoint');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("CoreGroupAccessPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.coregroupaccesspoint.name"):
    raise Exception("Resource role properties does not contain websphere.coregroupaccesspoint.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create CoreGroupAccessPoint on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('CoreGroupAccessPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("CoreGroupAccessPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.coregroupaccesspoint.name"):
    raise Exception("Resource role properties does not contain websphere.coregroupaccesspoint.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.coregroupaccesspoint.name", None));
  Util.addIfNotNone(properties, "coreGroup", roleProperties.optString("websphere.coregroupaccesspoint.coregroup", None));
  print "Creating CoreGroupAccessPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CoreGroupAccessPoint", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereBridgeInterface":
        BridgeInterface.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CoreGroupAccessPoint');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('CoreGroupAccessPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("CoreGroupAccessPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.coregroupaccesspoint.name"):
    raise Exception("Resource role properties does not contain websphere.coregroupaccesspoint.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.coregroupaccesspoint.name", None), "name","CoreGroupAccessPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.coregroupaccesspoint.coregroup", None), "coreGroup","CoreGroupAccessPoint");
  atts.append(['AccessPointGroup','']);
  if len(atts) != 0:
    print "Modifying CoreGroupAccessPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CoreGroupAccessPoint configuration up to date.";

  interfaces = Util.parseConfigIdListAttribute(objid, 'bridgeInterfaces', "CoreGroupAccessPoint");
  for interface in interfaces:
    Util.remove(interface);

  Property.removeProperties(objid, 'properties',"CoreGroupAccessPoint");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereBridgeInterface":
        BridgeInterface.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CoreGroupAccessPoint');
