from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HeaderCondition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHeaderCondition");
  exportedObject.put("roleName", "WebSphereHeaderCondition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.headercondition.headerkey", objid, "headerKey","HeaderCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.headercondition.headervalue", objid, "headerValue","HeaderCondition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"HeaderCondition");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HeaderCondition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('HeaderCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("HeaderCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "headerKey", roleProperties.optString("websphere.headercondition.headerkey", None));
  Util.addIfNotNone(properties, "headerValue", roleProperties.optString("websphere.headercondition.headervalue", None));
  print "Creating HeaderCondition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HeaderCondition", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('HeaderCondition');

def update(objid,jsonobject):
  Util.pushPathElement('HeaderCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("HeaderCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.headercondition.headerkey", None), "headerKey","HeaderCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.headercondition.headervalue", None), "headerValue","HeaderCondition");
  if len(atts) != 0:
    print "Modifying HeaderCondition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HeaderCondition configuration up to date.";

  Property.removeProperties(objid, 'properties',"HeaderCondition");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('HeaderCondition');
