from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAbstractDestination')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAbstractDestination");
  exportedObject.put("roleName", "WebSphereSIBAbstractDestination");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibabstractdestination.instancetype", objid, "instanceType","SIBAbstractDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibabstractdestination.identifier", objid, "identifier","SIBAbstractDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibabstractdestination.uuid", objid, "uuid","SIBAbstractDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibabstractdestination.description", objid, "description","SIBAbstractDestination");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAbstractDestination');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAbstractDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAbstractDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "instanceType", roleProperties.optString("websphere.sibabstractdestination.instancetype", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibabstractdestination.identifier", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibabstractdestination.uuid", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibabstractdestination.description", None));
  print "Creating SIBAbstractDestination with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAbstractDestination", parentid, properties);
  Util.popPathElement('SIBAbstractDestination');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAbstractDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAbstractDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibabstractdestination.instancetype", None), "instanceType","SIBAbstractDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibabstractdestination.identifier", None), "identifier","SIBAbstractDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibabstractdestination.uuid", None), "uuid","SIBAbstractDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibabstractdestination.description", None), "description","SIBAbstractDestination");
  if len(atts) != 0:
    print "Modifying SIBAbstractDestination with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAbstractDestination configuration up to date.";

  Util.popPathElement('SIBAbstractDestination');
