from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AllAuthenticatedUsersExt')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAllAuthenticatedUsersExt");
  exportedObject.put("roleName", "WebSphereAllAuthenticatedUsersExt");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.allauthenticatedusersext.name", objid, "name","AllAuthenticatedUsersExt");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.allauthenticatedusersext.accessid", objid, "accessId","AllAuthenticatedUsersExt");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AllAuthenticatedUsersExt');
  return result;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('AllAuthenticatedUsersExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("AllAuthenticatedUsersExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.allauthenticatedusersext.name", None));
  Util.addIfNotNone(properties, "accessId", roleProperties.optString("websphere.allauthenticatedusersext.accessid", None));
  print "Creating AllAuthenticatedUsersExt with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AllAuthenticatedUsersExt", parentid, properties, attName);
  Util.popPathElement('AllAuthenticatedUsersExt');

def update(objid,jsonobject):
  Util.pushPathElement('AllAuthenticatedUsersExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("AllAuthenticatedUsersExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.allauthenticatedusersext.name", None), "name","AllAuthenticatedUsersExt");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.allauthenticatedusersext.accessid", None), "accessId","AllAuthenticatedUsersExt");
  if len(atts) != 0:
    print "Modifying AllAuthenticatedUsersExt with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AllAuthenticatedUsersExt configuration up to date.";

  Util.popPathElement('AllAuthenticatedUsersExt');
