from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DeploymentTarget')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDeploymentTarget");
  exportedObject.put("roleName", "WebSphereDeploymentTarget");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.deploymenttarget.name", objid, "name","DeploymentTarget");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DeploymentTarget');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DeploymentTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeploymentTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.deploymenttarget.name", None));
  print "Creating DeploymentTarget with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DeploymentTarget", parentid, properties);
  Util.popPathElement('DeploymentTarget');

def update(objid,jsonobject):
  Util.pushPathElement('DeploymentTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeploymentTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.deploymenttarget.name", None), "name","DeploymentTarget");
  if len(atts) != 0:
    print "Modifying DeploymentTarget with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DeploymentTarget configuration up to date.";

  Util.popPathElement('DeploymentTarget');
