from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.discoverabledescriptiveproperty.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'DiscoverableDescriptiveProperty');

  containmentpath = "%(parentconpath)sDiscoverableDescriptiveProperty:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('DiscoverableDescriptiveProperty')

  name = Util.getRequiredAttribute(objid, "name", 'DiscoverableDescriptiveProperty');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDiscoverableDescriptiveProperty");
  exportedObject.put("roleName", "WebSphereDiscoverableDescriptiveProperty");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.discoverabledescriptiveproperty.name", objid, "name","DiscoverableDescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.discoverabledescriptiveproperty.range", objid, "range","DiscoverableDescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.discoverabledescriptiveproperty.validationexpression", objid, "validationExpression","DiscoverableDescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.discoverabledescriptiveproperty.nlsrangekey", objid, "nlsRangeKey","DiscoverableDescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.discoverabledescriptiveproperty.required", objid, "required","DiscoverableDescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.discoverabledescriptiveproperty.type", objid, "type","DiscoverableDescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.discoverabledescriptiveproperty.inclusive", objid, "inclusive","DiscoverableDescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.discoverabledescriptiveproperty.value", objid, "value","DiscoverableDescriptiveProperty");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.discoverabledescriptiveproperty.description", objid, "description","DiscoverableDescriptiveProperty");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DiscoverableDescriptiveProperty');
  return result;


'''
  The Property objects should only be created by Property.createObjIfRole(...) in parent object.
  Remove doImport(..) so importobject.py will not create the Propety object the second time via containmentpath.
'''
def _doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("DiscoverableDescriptiveProperty resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.discoverabledescriptiveproperty.name"):
    raise Exception("Resource role properties does not contain websphere.discoverabledescriptiveproperty.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create DiscoverableDescriptiveProperty on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('DiscoverableDescriptiveProperty')
  if not jsonobject.has("roleProperties"):
    raise Exception("DiscoverableDescriptiveProperty resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.discoverabledescriptiveproperty.name"):
    raise Exception("Resource role properties does not contain websphere.discoverabledescriptiveproperty.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.discoverabledescriptiveproperty.name", None));
  Util.addIfNotNone(properties, "range", roleProperties.optString("websphere.discoverabledescriptiveproperty.range", None));
  Util.addIfNotNone(properties, "validationExpression", roleProperties.optString("websphere.discoverabledescriptiveproperty.validationexpression", None));
  Util.addIfNotNone(properties, "nlsRangeKey", roleProperties.optString("websphere.discoverabledescriptiveproperty.nlsrangekey", None));
  Util.addIfNotNone(properties, "required", roleProperties.optString("websphere.discoverabledescriptiveproperty.required", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.discoverabledescriptiveproperty.type", None));
  Util.addIfNotNone(properties, "inclusive", roleProperties.optString("websphere.discoverabledescriptiveproperty.inclusive", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.discoverabledescriptiveproperty.value", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.discoverabledescriptiveproperty.description", None));
  print "Creating DiscoverableDescriptiveProperty with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DiscoverableDescriptiveProperty", parentid, properties, attName);
  Util.popPathElement('DiscoverableDescriptiveProperty');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('DiscoverableDescriptiveProperty')
  if not jsonobject.has("roleProperties"):
    raise Exception("DiscoverableDescriptiveProperty resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.discoverabledescriptiveproperty.name"):
    raise Exception("Resource role properties does not contain websphere.discoverabledescriptiveproperty.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.discoverabledescriptiveproperty.name", None), "name","DiscoverableDescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.discoverabledescriptiveproperty.range", None), "range","DiscoverableDescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.discoverabledescriptiveproperty.validationexpression", None), "validationExpression","DiscoverableDescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.discoverabledescriptiveproperty.nlsrangekey", None), "nlsRangeKey","DiscoverableDescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.discoverabledescriptiveproperty.required", None), "required","DiscoverableDescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.discoverabledescriptiveproperty.type", None), "type","DiscoverableDescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.discoverabledescriptiveproperty.inclusive", None), "inclusive","DiscoverableDescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.discoverabledescriptiveproperty.value", None), "value","DiscoverableDescriptiveProperty");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.discoverabledescriptiveproperty.description", None), "description","DiscoverableDescriptiveProperty");
  if len(atts) != 0:
    print "Modifying DiscoverableDescriptiveProperty with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DiscoverableDescriptiveProperty configuration up to date.";

  Util.popPathElement('DiscoverableDescriptiveProperty');
