from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from BackupCluster import BackupCluster

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PMEClusterExtension')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePMEClusterExtension");
  exportedObject.put("roleName", "WebSpherePMEClusterExtension");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  backupCluster = Util.getOptionalAttribute(objid, 'backupCluster', "PMEClusterExtension");
  if backupCluster is not None and len(backupCluster) > 0:
    returndict = Util.createTypeFolder(respath, "BackupCluster", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, BackupCluster._export(backupCluster, currespath, "BackupCluster"));    

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PMEClusterExtension');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PMEClusterExtension')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMEClusterExtension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating PMEClusterExtension with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PMEClusterExtension", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereBackupCluster":
        BackupCluster.create(objid, curjsonobject);

  Util.popPathElement('PMEClusterExtension');

def update(objid,jsonobject):
  Util.pushPathElement('PMEClusterExtension')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMEClusterExtension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying PMEClusterExtension with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PMEClusterExtension configuration up to date.";

  backupCluster = Util.getOptionalAttribute(objid, 'backupCluster',"PMEClusterExtension");
  if backupCluster is not None and len(backupCluster) > 0:
    Util.remove(backupCluster);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereBackupCluster":
        BackupCluster.create(objid, curjsonobject);

  Util.popPathElement('PMEClusterExtension');

def getPMEClusterExtensions(objid):
  pmeClusterExtension = Util.getAssociatedObjects(objid, "PMEClusterExtension");
  return pmeClusterExtension;
