from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASEjbRefBinding')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASEjbRefBinding");
  exportedObject.put("roleName", "WebSphereWASEjbRefBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasejbrefbinding.jndiname", objid, "jndiName","WASEjbRefBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASEjbRefBinding');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASEjbRefBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASEjbRefBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.wasejbrefbinding.jndiname", None));
  print "Creating WASEjbRefBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASEjbRefBinding", parentid, properties);
  Util.popPathElement('WASEjbRefBinding');

def update(objid,jsonobject):
  Util.pushPathElement('WASEjbRefBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASEjbRefBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasejbrefbinding.jndiname", None), "jndiName","WASEjbRefBinding");
  if len(atts) != 0:
    print "Modifying WASEjbRefBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASEjbRefBinding configuration up to date.";

  Util.popPathElement('WASEjbRefBinding');
