from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from ExtensionMBean import ExtensionMBean
from utilities import Util

__name_att__ = "websphere.extensionmbeanprovider.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'ExtensionMBeanProvider');

  containmentpath = "%(parentconpath)sExtensionMBeanProvider:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('ExtensionMBeanProvider')

  name = Util.getRequiredAttribute(objid, "name", 'ExtensionMBeanProvider');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereExtensionMBeanProvider");
  exportedObject.put("roleName", "WebSphereExtensionMBeanProvider");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.extensionmbeanprovider.classpath", objid, "classpath","ExtensionMBeanProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extensionmbeanprovider.name", objid, "name","ExtensionMBeanProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extensionmbeanprovider.description", objid, "description","ExtensionMBeanProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders={};

  i = 0;
  extensionMBeans = Util.parseConfigIdListAttribute(objid, 'extensionMBeans',"ExtensionMBeanProvider");
  for extensionMBean in extensionMBeans:
    if len(extensionMBean) > 0:
      returndict = Util.createTypeFolder(respath, "ExtensionMBean", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ExtensionMBean._export(extensionMBean, currespath, "ExtensionMBean%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ExtensionMBeanProvider');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("ExtensionMBeanProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.extensionmbeanprovider.name"):
    raise Exception("Resource role properties does not contain websphere.extensionmbeanprovider.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create ExtensionMBeanProvider on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('ExtensionMBeanProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExtensionMBeanProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.extensionmbeanprovider.name"):
    raise Exception("Resource role properties does not contain websphere.extensionmbeanprovider.name!");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.extensionmbeanprovider.classpath", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.extensionmbeanprovider.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.extensionmbeanprovider.description", None));
  print "Creating ExtensionMBeanProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ExtensionMBeanProvider", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereExtensionMBean":
         ExtensionMBean.create(objid, curjsonobject);
  Util.popPathElement('ExtensionMBeanProvider');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ExtensionMBeanProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExtensionMBeanProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.extensionmbeanprovider.name"):
    raise Exception("Resource role properties does not contain websphere.extensionmbeanprovider.name!");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.extensionmbeanprovider.classpath", None), "classpath","ExtensionMBeanProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extensionmbeanprovider.name", None), "name","ExtensionMBeanProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extensionmbeanprovider.description", None), "description","ExtensionMBeanProvider");
  if len(atts) != 0:
    print "Modifying ExtensionMBeanProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ExtensionMBeanProvider configuration up to date.";

  extensionMBeans = Util.parseConfigIdListAttribute(objid, 'extensionMBeans',"ExtensionMBeanProvider");
  for extensionMBean in extensionMBeans:
    if len(extensionMBean) > 0:
      Util.remove(extensionMBean);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereExtensionMBean":
         ExtensionMBean.create(objid, curjsonobject);
  Util.popPathElement('ExtensionMBeanProvider');
