from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('License')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLicense");
  exportedObject.put("roleName", "WebSphereLicense");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.license.description", objid, "description","License");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.license.required", objid, "required","License");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'License');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('License');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('License')
  if not jsonobject.has("roleProperties"):
    raise Exception("License resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.license.description", None));
  Util.addIfNotNone(properties, "required", roleProperties.optString("websphere.license.required", None));
  print "Creating License with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("License", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('License');

def update(objid,jsonobject):
  Util.pushPathElement('License')
  if not jsonobject.has("roleProperties"):
    raise Exception("License resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.license.description", None), "description","License");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.license.required", None), "required","License");
  if len(atts) != 0:
    print "Modifying License with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "License configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'License');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('License');
