from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Service import Service
from Component import Component
from Property import Property
from utilities import Util
from StateManageable import StateManageable
from HTTPProxyServerSettings import HTTPProxyServerSettings
from SIPProxyServerSettings import SIPProxyServerSettings

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Proxy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereProxy");
  exportedObject.put("roleName", "WebSphereProxy");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxy.name", objid, "name","Proxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxy.enablecustomsecuritylevel", objid, "enableCustomSecurityLevel","Proxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.proxy.adminsecuritylevel", objid, "adminSecurityLevel","Proxy");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"Proxy");
  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "Proxy");
  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "Proxy");
  
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"Proxy");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));    

  httpProxyServerSettings = Util.getOptionalAttribute(objid, 'httpProxyServerSettings', "Proxy");
  if httpProxyServerSettings is not None and len(httpProxyServerSettings) > 0:
    returndict = Util.createTypeFolder(respath, "HTTPProxyServerSettings", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, HTTPProxyServerSettings._export(httpProxyServerSettings, currespath, "HTTP Proxy Server Settings"));

  sipProxyServerSettings = Util.getOptionalAttribute(objid, 'sipProxyServerSettings', "Proxy");
  if sipProxyServerSettings is not None and len(sipProxyServerSettings) > 0:
    returndict = Util.createTypeFolder(respath, "SIPProxyServerSettings", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIPProxyServerSettings._export(sipProxyServerSettings, currespath, "SIP Proxy Server Settings"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Proxy');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('Proxy')
  if not jsonobject.has("roleProperties"):
    raise Exception("Proxy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.proxy.name", None));
  Util.addIfNotNone(properties, "enableCustomSecurityLevel", roleProperties.optString("websphere.proxy.enablecustomsecuritylevel", None));
  Util.addIfNotNone(properties, "adminSecurityLevel", roleProperties.optString("websphere.proxy.adminsecuritylevel", None));
  print "Creating Proxy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Proxy", parentid, properties);

  Property.removeProperties(objid, 'properties',"Proxy");
  Component.removeComponents(objid, 'components', "Proxy");
  Service.removeServices(objid, 'services', "Proxy");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"Proxy");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);    

  httpProxyServerSettings = Util.getOptionalAttribute(objid, 'httpProxyServerSettings', "Proxy");
  if httpProxyServerSettings is not None and len(httpProxyServerSettings) > 0:
    Util.remove(httpProxyServerSettings);

  sipProxyServerSettings = Util.getOptionalAttribute(objid, 'sipProxyServerSettings', "Proxy");
  if sipProxyServerSettings is not None and len(sipProxyServerSettings) > 0:
    Util.remove(sipProxyServerSettings);

  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:    
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);
          elif currole == "WebSphereHTTPProxyServerSettings":
            HTTPProxyServerSettings.create(objid, curjsonobject);
          elif currole == "WebSphereSIPProxyServerSettings":
            SIPProxyServerSettings.create(objid, curjsonobject);
  Util.popPathElement('Proxy');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('Proxy')
  if not jsonobject.has("roleProperties"):
    raise Exception("Proxy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxy.name", None), "name","Proxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxy.enablecustomsecuritylevel", None), "enableCustomSecurityLevel","Proxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.proxy.adminsecuritylevel", None), "adminSecurityLevel","Proxy");
  if len(atts) != 0:
    print "Modifying Proxy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Proxy configuration up to date.";

  Property.removeProperties(objid, 'properties',"Proxy");
  Component.removeComponents(objid, 'components', "Proxy");
  Service.removeServices(objid, 'services', "Proxy");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"Proxy");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);    

  httpProxyServerSettings = Util.getOptionalAttribute(objid, 'httpProxyServerSettings', "Proxy");
  if httpProxyServerSettings is not None and len(httpProxyServerSettings) > 0:
    Util.remove(httpProxyServerSettings);

  sipProxyServerSettings = Util.getOptionalAttribute(objid, 'sipProxyServerSettings', "Proxy");
  if sipProxyServerSettings is not None and len(sipProxyServerSettings) > 0:
    Util.remove(sipProxyServerSettings);

  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:    
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);
          elif currole == "WebSphereHTTPProxyServerSettings":
            HTTPProxyServerSettings.create(objid, curjsonobject);
          elif currole == "WebSphereSIPProxyServerSettings":
            SIPProxyServerSettings.create(objid, curjsonobject);
  Util.popPathElement('Proxy');
