from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIPContainerInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'SIPContainerInboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIPContainerInboundChannel");
  exportedObject.put("roleName", "WebSphereSIPContainerInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipcontainerinboundchannel.name", objid, "name","SIPContainerInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipcontainerinboundchannel.discriminationweight", objid, "discriminationWeight","SIPContainerInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SIPContainerInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIPContainerInboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIPContainerInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPContainerInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sipcontainerinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.sipcontainerinboundchannel.discriminationweight", None));
  print "Creating SIPContainerInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIPContainerInboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIPContainerInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('SIPContainerInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPContainerInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipcontainerinboundchannel.name", None), "name","SIPContainerInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipcontainerinboundchannel.discriminationweight", None), "discriminationWeight","SIPContainerInboundChannel");
  if len(atts) != 0:
    print "Modifying SIPContainerInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIPContainerInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"SIPContainerInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIPContainerInboundChannel');
