/*
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2002, 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.XTrustProvider;

XTrustProvider.install();

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def ch = new CommandHelper(new File("."));
def props = apTool.getStepProperties();

def webSphereUser = props['wasuser'];
def webSpherePassword = props['waspassword'];
def profilePath = props['profilePath'];
def wsadminPath = props['commandPath'];
def wasPort = props['port'];
def wasHost = props['host'];
def wasConnType = props['connType'];
def configurationFile = props['configurationFile'];


def WSDISC_HOME = System.getenv("PLUGIN_HOME");

if (configurationFile == "") {
  throw new Exception("Exception: No configuration file was specified.")
}

def isJythonUpgraded = {
    def jythonUpgrade = false;
    def wsadminExe = wsadminPath;
    while (wsadminExe.endsWith(File.separator)) {
        wsadminExe = wsadminExe.substring(0, wsadminExe.length()-1);
    }

    if (File.separator == "\\") {//windows platform
        wsadminExe = wsadminExe + File.separator + "wsadmin.bat";
    }
    else {
        wsadminExe = wsadminExe + File.separator + "wsadmin.sh";
    }

    def cmdArgs = [wsadminExe];

    cmdArgs << "-h";
    cmdArgs << "jython";

    println "Running Check to see if jython was upgraded";
    println cmdArgs.join(" ");

    Process proc = cmdArgs.execute();
    proc.out.close();
    OutputStream oStream = new ByteArrayOutputStream();
    OutputStream eStream = new ByteArrayOutputStream();
    proc.waitForProcessOutput(oStream, eStream);
    String output = oStream.toString();
    int usejython21 = output.indexOf("usejython21");
    if (usejython21 != -1) {
      jythonUpgrade = true;
    }

    return jythonUpgrade;
}

def wsadminExe = wsadminPath;

while (wsadminExe.endsWith(File.separator)) {
    wsadminExe = wsadminExe.substring(0, wsadminExe.length()-1);
}

if (apTool.isWindows) {
    wsadminExe = wsadminExe + File.separator + "wsadmin.bat";
}
else {
    wsadminExe = wsadminExe + File.separator + "wsadmin.sh";
}


def cmdArgs = [wsadminExe];    

if (wasHost?.trim() && !wasHost.startsWith("p:")) {
    cmdArgs << "-host";
    cmdArgs << wasHost.trim();
}

if (wasPort?.trim() && !wasPort.startsWith("p:")) {
    cmdArgs << "-port";
    cmdArgs << wasPort.trim();
}

if (wasConnType?.trim() && !wasConnType.startsWith("p:")) {
    cmdArgs << "-conntype";
    cmdArgs << wasConnType.trim();
}

if ( webSphereUser?.trim() && !webSphereUser.trim().startsWith("p:")) {
    println "Using credentials";
    cmdArgs << "-user" << webSphereUser << "-password" << webSpherePassword;
}

if (isJythonUpgraded() == true) {
    cmdArgs << "-usejython21";
    cmdArgs << "true";
}

cmdArgs << "-wsadmin_classpath" << "${WSDISC_HOME}" + java.io.File.separator + "lib" + java.io.File.separator + "securedata.jar" + java.io.File.pathSeparator + "${WSDISC_HOME}" + java.io.File.separator + "lib" + java.io.File.separator + "jettison-1.1.jar" + java.io.File.pathSeparator + "${WSDISC_HOME}" + java.io.File.separator + "lib" + java.io.File.separator + "log4j.jar" + java.io.File.pathSeparator + "${WSDISC_HOME}" + java.io.File.separator + "lib" + java.io.File.separator + "commons-codec.jar" + java.io.File.pathSeparator + "${WSDISC_HOME}" + java.io.File.separator + "lib" + java.io.File.separator + "CommonsUtil.jar"

cmdArgs << "-f" << "${WSDISC_HOME}" + java.io.File.separator + "jythonScripts" + java.io.File.separator + "importobject.py";

cmdArgs << this.args[0].replace("\\","\\\\");
ch.runCommand("Importing object", cmdArgs, "ucd.properties.secret=${apTool.getEncKey()}");

