from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ActivitySessionService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereActivitySessionService");
  exportedObject.put("roleName", "WebSphereActivitySessionService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.activitysessionservice.enable", objid, "enable","ActivitySessionService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.activitysessionservice.defaulttimeout", objid, "defaultTimeout","ActivitySessionService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties', "ActivitySessionService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ActivitySessionService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ActivitySessionService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ActivitySessionService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.activitysessionservice.enable", None));
  Util.addIfNotNone(properties, "defaultTimeout", roleProperties.optString("websphere.activitysessionservice.defaulttimeout", None));
  print "Creating ActivitySessionService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ActivitySessionService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ActivitySessionService');


def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ActivitySessionService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ActivitySessionService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.activitysessionservice.enable", None), "enable","ActivitySessionService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.activitysessionservice.defaulttimeout", None), "defaultTimeout","ActivitySessionService");
  if len(atts) != 0:
    print "Modifying ActivitySessionService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ActivitySessionService configuration up to date.";

  Property.removeProperties(objid, 'properties',"ActivitySessionService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ActivitySessionService');
