from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.checkpoint.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'Checkpoint');

  containmentpath = "%(parentconpath)sCheckpoint:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('Checkpoint')

  name = Util.getRequiredAttribute(objid, "name", 'Checkpoint');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCheckpoint");
  exportedObject.put("roleName", "WebSphereCheckpoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.checkpoint.name", objid, "name","Checkpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.checkpoint.doccount", objid, "docCount","Checkpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.checkpoint.type", objid, "type","Checkpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.checkpoint.description", objid, "description","Checkpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.checkpoint.sequence", objid, "sequence","Checkpoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Checkpoint');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("Checkpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.checkpoint.name"):
    raise Exception("Resource role properties does not contain websphere.checkpoint.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create Checkpoint on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('Checkpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("Checkpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.checkpoint.name"):
    raise Exception("Resource role properties does not contain websphere.checkpoint.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.checkpoint.name", None));
  Util.addIfNotNone(properties, "docCount", roleProperties.optString("websphere.checkpoint.doccount", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.checkpoint.type", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.checkpoint.description", None));
  Util.addIfNotNone(properties, "sequence", roleProperties.optString("websphere.checkpoint.sequence", None));
  print "Creating Checkpoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Checkpoint", parentid, properties);
  Util.popPathElement('Checkpoint');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('Checkpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("Checkpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.checkpoint.name"):
    raise Exception("Resource role properties does not contain websphere.checkpoint.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.checkpoint.name", None), "name","Checkpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.checkpoint.doccount", None), "docCount","Checkpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.checkpoint.type", None), "type","Checkpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.checkpoint.description", None), "description","Checkpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.checkpoint.sequence", None), "sequence","Checkpoint");
  if len(atts) != 0:
    print "Modifying Checkpoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Checkpoint configuration up to date.";

  Util.popPathElement('Checkpoint');
