from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from ProcessDef import ProcessDef
from JavaProcessDef import JavaProcessDef
from NamedProcessDef import NamedProcessDef
from NamedJavaProcessDef import NamedJavaProcessDef
from utilities import Util

__name_att__ = "websphere.elasticitycustomprocessdefs.name"

def getProcessDefObjIds(objid):
  return Util.parseConfigIdListAttribute(objid, 'definitions', 'ElasticityCustomProcessDefs');

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'ElasticityCustomProcessDefs');

  containmentpath = "%(parentconpath)sElasticityCustomProcessDefs:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('ElasticityCustomProcessDefs')

  name = Util.getRequiredAttribute(objid, "name", 'ElasticityCustomProcessDefs');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereElasticityCustomProcessDefs");
  exportedObject.put("roleName", "WebSphereElasticityCustomProcessDefs");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.elasticitycustomprocessdefs.name", objid, "name","ElasticityCustomProcessDefs");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  procs = getProcessDefObjIds(objid);
  i = 0;
  if procs is not None and len(procs) > 0:
    for procid in procs:
      if len(procid) > 0:
        if procid.find("#ProcessDef_") > 0:
          returndict = Util.createTypeFolder(respath, "ProcessDef", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, ProcessDef._export(procid, currespath, 'ProcessDef%s' % i));
          i = i + 1;
        elif procid.find("#JavaProcessDef_") > 0:
          returndict = Util.createTypeFolder(respath, "JavaProcessDef", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, JavaProcessDef._export(procid, currespath, 'JavaProcessDef%s' % i));
          i = i + 1;
        elif procid.find("#NamedProcessDef_") > 0:
          returndict = Util.createTypeFolder(respath, "NamedProcessDef", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, NamedProcessDef._export(procid, currespath, Util.getRequiredAttribute(procid, "name", 'Server')));
          i = i + 1;
        elif procid.find("#NamedJavaProcessDef_") > 0:
          returndict = Util.createTypeFolder(respath, "NamedJavaProcessDef", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, NamedJavaProcessDef._export(procid, currespath, Util.getRequiredAttribute(procid, "name", 'Server')));
          i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ElasticityCustomProcessDefs');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("ElasticityCustomProcessDefs resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.elasticitycustomprocessdefs.name"):
    raise Exception("Resource role properties does not contain websphere.elasticitycustomprocessdefs.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create ElasticityCustomProcessDefs on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('ElasticityCustomProcessDefs')
  if not jsonobject.has("roleProperties"):
    raise Exception("ElasticityCustomProcessDefs resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.elasticitycustomprocessdefs.name"):
    raise Exception("Resource role properties does not contain websphere.elasticitycustomprocessdefs.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.elasticitycustomprocessdefs.name", None));
  print "Creating ElasticityCustomProcessDefs with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ElasticityCustomProcessDefs", parentid, properties);

  for prop in getProcessDefObjIds(objid):
    Util.remove(prop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereProcessDef":
        ProcessDef.create(objid, curjsonobject, 'definitions');
      elif currole == "WebSphereJavaProcessDef":
        JavaProcessDef.create(objid, curjsonobject, 'definitions');
      elif currole == "WebSphereNamedProcessDef":
        NamedProcessDef.create(objid, curjsonobject, 'definitions');
      elif currole == "WebSphereNamedJavaProcessDef":
        NamedJavaProcessDef.create(objid, curjsonobject, 'definitions');
  Util.popPathElement('ElasticityCustomProcessDefs');

  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ElasticityCustomProcessDefs')
  if not jsonobject.has("roleProperties"):
    raise Exception("ElasticityCustomProcessDefs resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.elasticitycustomprocessdefs.name"):
    raise Exception("Resource role properties does not contain websphere.elasticitycustomprocessdefs.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.elasticitycustomprocessdefs.name", None), "name","ElasticityCustomProcessDefs");
  if len(atts) != 0:
    print "Modifying ElasticityCustomProcessDefs with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ElasticityCustomProcessDefs configuration up to date.";

  for prop in getProcessDefObjIds(objid):
    Util.remove(prop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereProcessDef":
        ProcessDef.create(objid, curjsonobject, 'definitions');
      elif currole == "WebSphereJavaProcessDef":
        JavaProcessDef.create(objid, curjsonobject, 'definitions');
      elif currole == "WebSphereNamedProcessDef":
        NamedProcessDef.create(objid, curjsonobject, 'definitions');
      elif currole == "WebSphereNamedJavaProcessDef":
        NamedJavaProcessDef.create(objid, curjsonobject, 'definitions');

  Util.popPathElement('ElasticityCustomProcessDefs');
