from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('FailRoute')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereFailRoute");
  exportedObject.put("roleName", "WebSphereFailRoute");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.failroute.failstatuscode", objid, "failStatusCode","FailRoute");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('FailRoute');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('FailRoute')
  if not jsonobject.has("roleProperties"):
    raise Exception("FailRoute resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "failStatusCode", roleProperties.optString("websphere.failroute.failstatuscode", None));
  print "Creating FailRoute with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("FailRoute", parentid, properties);
  Util.popPathElement('FailRoute');

def update(objid,jsonobject):
  Util.pushPathElement('FailRoute')
  if not jsonobject.has("roleProperties"):
    raise Exception("FailRoute resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.failroute.failstatuscode", None), "failStatusCode","FailRoute");
  if len(atts) != 0:
    print "Modifying FailRoute with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "FailRoute configuration up to date.";

  Util.popPathElement('FailRoute');
