from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBMQClientLinkAdvancedProperties import SIBMQClientLinkAdvancedProperties

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMQClientLink')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMQClientLink");
  exportedObject.put("roleName", "WebSphereSIBMQClientLink");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlink.uuid", objid, "uuid","SIBMQClientLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlink.name", objid, "name","SIBMQClientLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlink.initialstate", objid, "initialState","SIBMQClientLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlink.heartbeat", objid, "heartBeat","SIBMQClientLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlink.qmname", objid, "qmName","SIBMQClientLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlink.defaultqm", objid, "defaultQM","SIBMQClientLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlink.migrateddefinition", objid, "migratedDefinition","SIBMQClientLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlink.maxmsgsize", objid, "maxMsgSize","SIBMQClientLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlink.channelname", objid, "channelName","SIBMQClientLink");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqclientlink.description", objid, "description","SIBMQClientLink");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  advancedProperties = Util.getOptionalAttribute(objid, 'advancedProperties', "SIBMQClientLink");
  if (advancedProperties is not None) and (len(advancedProperties) > 0):
    returndict = Util.createTypeFolder(respath, "SIBMQClientLinkAdvancedProperties", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBMQClientLinkAdvancedProperties._export(advancedProperties, currespath, "SIBMQClientLinkAdvancedProperties"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMQClientLink');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMQClientLink')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQClientLink resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibmqclientlink.uuid", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibmqclientlink.name", None));
  Util.addIfNotNone(properties, "initialState", roleProperties.optString("websphere.sibmqclientlink.initialstate", None));
  Util.addIfNotNone(properties, "heartBeat", roleProperties.optString("websphere.sibmqclientlink.heartbeat", None));
  Util.addIfNotNone(properties, "qmName", roleProperties.optString("websphere.sibmqclientlink.qmname", None));
  Util.addIfNotNone(properties, "defaultQM", roleProperties.optString("websphere.sibmqclientlink.defaultqm", None));
  Util.addIfNotNone(properties, "migratedDefinition", roleProperties.optString("websphere.sibmqclientlink.migrateddefinition", None));
  Util.addIfNotNone(properties, "maxMsgSize", roleProperties.optString("websphere.sibmqclientlink.maxmsgsize", None));
  Util.addIfNotNone(properties, "channelName", roleProperties.optString("websphere.sibmqclientlink.channelname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibmqclientlink.description", None));
  print "Creating SIBMQClientLink with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMQClientLink", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBMQClientLinkAdvancedProperties":
        SIBMQClientLinkAdvancedProperties.create(objid, curjsonobject);
  Util.popPathElement('SIBMQClientLink');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMQClientLink')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQClientLink resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlink.uuid", None), "uuid","SIBMQClientLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlink.name", None), "name","SIBMQClientLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlink.initialstate", None), "initialState","SIBMQClientLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlink.heartbeat", None), "heartBeat","SIBMQClientLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlink.qmname", None), "qmName","SIBMQClientLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlink.defaultqm", None), "defaultQM","SIBMQClientLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlink.migrateddefinition", None), "migratedDefinition","SIBMQClientLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlink.maxmsgsize", None), "maxMsgSize","SIBMQClientLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlink.channelname", None), "channelName","SIBMQClientLink");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqclientlink.description", None), "description","SIBMQClientLink");
  if len(atts) != 0:
    print "Modifying SIBMQClientLink with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMQClientLink configuration up to date.";

  advancedProperties = Util.getOptionalAttribute(objid, 'advancedProperties', "SIBMQClientLink");
  if (advancedProperties is not None) and (len(advancedProperties) > 0):
    Util.remove(advancedProperties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBMQClientLinkAdvancedProperties":
        SIBMQClientLinkAdvancedProperties.create(objid, curjsonobject);
  Util.popPathElement('SIBMQClientLink');
