from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from PrimaryAdminExt import PrimaryAdminExt
from EveryoneExt import EveryoneExt
from AllAuthenticatedUsersExt import AllAuthenticatedUsersExt
from ServerExt import ServerExt
from AllAuthenticatedUsersInTrustedRealmsExt import AllAuthenticatedUsersInTrustedRealmsExt

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SpecialSubjectExt')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSpecialSubjectExt");
  exportedObject.put("roleName", "WebSphereSpecialSubjectExt");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.specialsubjectext.name", objid, "name","SpecialSubjectExt");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.specialsubjectext.accessid", objid, "accessId","SpecialSubjectExt");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SpecialSubjectExt');
  return result;



def create(parentid, jsonobject, attName = None):
  Util.pushPathElement('SpecialSubjectExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("SpecialSubjectExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.specialsubjectext.name", None));
  Util.addIfNotNone(properties, "accessId", roleProperties.optString("websphere.specialsubjectext.accessid", None));
  print "Creating SpecialSubjectExt with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SpecialSubjectExt", parentid, properties, attName);
  Util.popPathElement('SpecialSubjectExt');

def update(objid,jsonobject):
  Util.pushPathElement('SpecialSubjectExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("SpecialSubjectExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.specialsubjectext.name", None), "name","SpecialSubjectExt");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.specialsubjectext.accessid", None), "accessId","SpecialSubjectExt");
  if len(atts) != 0:
    print "Modifying SpecialSubjectExt with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SpecialSubjectExt configuration up to date.";
  Util.popPathElement('SpecialSubjectExt');

def removeSpecialSubjectExts(objid, attributeName, parentType):
  specialSubjectExts = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if specialSubjectExts is not None and len(specialSubjectExts) > 0:
    for specialSubjectExt in specialSubjectExts:
      if len(specialSubjectExt) > 0:
        Util.remove(specialSubjectExt);    
    
def exportSpecialSubjectExts(objid, respath, extraObjects, typeFolders, attributeName, parentType, folderName = None):
  
  counterPrimaryAdminExt = 0;
  counterEveryoneExt = 0;
  counterAllAuthenticatedUsersExt = 0;
  counterServerExt = 0;
  counterAllAuthenticatedUsersInTrustedRealmsExt = 0;  
  counterSpecialSubjectExt = 0;


  specialSubjectExts = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if specialSubjectExts is not None and len(specialSubjectExts) > 0:
    for specialSubjectExt in specialSubjectExts:
      if len(specialSubjectExt) > 0:
        if specialSubjectExt.find("#PrimaryAdminExt_") != -1:
          if folderName is not None and len(folderName) > 0:
            returndict = Util.createTypeFolder(respath, folderName, typeFolders);
          else:
            returndict = Util.createTypeFolder(respath, "PrimaryAdminExt", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, PrimaryAdminExt._export(specialSubjectExt, currespath, 'PrimaryAdminExt%s' % counterPrimaryAdminExt));
          counterPrimaryAdminExt = counterPrimaryAdminExt + 1;
        elif specialSubjectExt.find("#EveryoneExt_") != -1:
          if folderName is not None and len(folderName) > 0:
            returndict = Util.createTypeFolder(respath, folderName, typeFolders);
          else:
            returndict = Util.createTypeFolder(respath, "EveryoneExt", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, EveryoneExt._export(specialSubjectExt, currespath, 'EveryoneExt%s' % counterEveryoneExt));
          counterEveryoneExt = counterEveryoneExt + 1;
        elif specialSubjectExt.find("#AllAuthenticatedUsersExt_") != -1:
          if folderName is not None and len(folderName) > 0:
            returndict = Util.createTypeFolder(respath, folderName, typeFolders);
          else:
            returndict = Util.createTypeFolder(respath, "AllAuthenticatedUsersExt", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, AllAuthenticatedUsersExt._export(specialSubjectExt, currespath, 'AllAuthenticatedUsersExt%s' % counterAllAuthenticatedUsersExt));
          counterAllAuthenticatedUsersExt = counterAllAuthenticatedUsersExt + 1;
        elif specialSubjectExt.find("#ServerExt_") != -1:
          if folderName is not None and len(folderName) > 0:
            returndict = Util.createTypeFolder(respath, folderName, typeFolders);
          else:
            returndict = Util.createTypeFolder(respath, "ServerExt", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, ServerExt._export(specialSubjectExt, currespath, 'ServerExt%s' % counterServerExt));
          counterServerExt = counterServerExt + 1;
        elif specialSubjectExt.find("#AllAuthenticatedUsersInTrustedRealmsExt_") != -1:
          if folderName is not None and len(folderName) > 0:
            returndict = Util.createTypeFolder(respath, folderName, typeFolders);
          else:
            returndict = Util.createTypeFolder(respath, "AllAuthenticatedUsersInTrustedRealmsExt", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, AllAuthenticatedUsersInTrustedRealmsExt._export(specialSubjectExt, currespath, 'AllAuthenticatedUsersInTrustedRealmsExt%s' % counterAllAuthenticatedUsersInTrustedRealmsExt));
          counterAllAuthenticatedUsersInTrustedRealmsExt = counterAllAuthenticatedUsersInTrustedRealmsExt + 1;
        elif specialSubjectExt.find("#SpecialSubjectExt_") != -1:
          if folderName is not None and len(folderName) > 0:
            returndict = Util.createTypeFolder(respath, folderName, typeFolders);
          else:
            returndict = Util.createTypeFolder(respath, "SpecialSubjectExt", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, _export(specialSubjectExt, currespath, 'SpecialSubjectExt%s' % counterSpecialSubjectExt));
          counterSpecialSubjectExt = counterSpecialSubjectExt + 1;
          
  return extraObjects;

def createObjIfRole(objid, curjsonobject, currole, attName = None):
  if currole == "WebSpherePrimaryAdminExt":
    PrimaryAdminExt.create(objid, curjsonobject, attName);
    return 1;
  elif currole == "WebSphereEveryoneExt":
    EveryoneExt.create(objid, curjsonobject, attName);
    return 1;
  elif currole == "WebSphereAllAuthenticatedUsersExt":
    AllAuthenticatedUsersExt.create(objid, curjsonobject, attName);
    return 1;
  elif currole == "WebSphereServerExt":
    ServerExt.create(objid, curjsonobject, attName);
    return 1;
  elif currole == "WebSphereAllAuthenticatedUsersInTrustedRealmsExt":
    AllAuthenticatedUsersInTrustedRealmsExt.create(objid, curjsonobject, attName);
    return 1;
  elif currole == "WebSphereSpecialSubjectExt":
    create(objid, curjsonobject, attName);
    return 1;
  return 0;

    
