from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CustomErrorPagePolicy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCustomErrorPagePolicy");
  exportedObject.put("roleName", "WebSphereCustomErrorPagePolicy");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customerrorpagepolicy.errorpageappuri", objid, "errorPageAppURI","CustomErrorPagePolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customerrorpagepolicy.handlelocalerrors", objid, "handleLocalErrors","CustomErrorPagePolicy");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.customerrorpagepolicy.forwardheaders", objid, "forwardHeaders","CustomErrorPagePolicy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customerrorpagepolicy.handleremoteerrors", objid, "handleRemoteErrors","CustomErrorPagePolicy");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.customerrorpagepolicy.statuscodes", objid, "statusCodes","CustomErrorPagePolicy");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CustomErrorPagePolicy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CustomErrorPagePolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomErrorPagePolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "errorPageAppURI", roleProperties.optString("websphere.customerrorpagepolicy.errorpageappuri", None));
  Util.addIfNotNone(properties, "handleLocalErrors", roleProperties.optString("websphere.customerrorpagepolicy.handlelocalerrors", None));
  Util.addPathProperty(properties, "forwardHeaders", roleProperties.optString("websphere.customerrorpagepolicy.forwardheaders", None));
  Util.addIfNotNone(properties, "handleRemoteErrors", roleProperties.optString("websphere.customerrorpagepolicy.handleremoteerrors", None));
  Util.addPathProperty(properties, "statusCodes", roleProperties.optString("websphere.customerrorpagepolicy.statuscodes", None));
  print "Creating CustomErrorPagePolicy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CustomErrorPagePolicy", parentid, properties);
  Util.popPathElement('CustomErrorPagePolicy');

def update(objid,jsonobject):
  Util.pushPathElement('CustomErrorPagePolicy')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomErrorPagePolicy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customerrorpagepolicy.errorpageappuri", None), "errorPageAppURI","CustomErrorPagePolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customerrorpagepolicy.handlelocalerrors", None), "handleLocalErrors","CustomErrorPagePolicy");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.customerrorpagepolicy.forwardheaders", None), "forwardHeaders","CustomErrorPagePolicy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customerrorpagepolicy.handleremoteerrors", None), "handleRemoteErrors","CustomErrorPagePolicy");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.customerrorpagepolicy.statuscodes", None), "statusCodes","CustomErrorPagePolicy");
  if len(atts) != 0:
    print "Modifying CustomErrorPagePolicy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CustomErrorPagePolicy configuration up to date.";

  Util.popPathElement('CustomErrorPagePolicy');
