from org.codehaus.jettison.json import JSONObject, JSONArray
from utilities import Util
from Property import Property
from HTTPRequestHeaderAction import HTTPRequestHeaderAction
from HTTPResponseHeaderAction import HTTPResponseHeaderAction
from HTTPResponseCompressionAction import HTTPResponseCompressionAction
from RoutingAction import RoutingAction

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HTTPRequestCompressionAction')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHTTPRequestCompressionAction");
  exportedObject.put("roleName", "WebSphereHTTPRequestCompressionAction");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httprequestcompressionaction.name", objid, "name","HTTPRequestCompressionAction");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httprequestcompressionaction.compressiontype", objid, "compressionType","HTTPRequestCompressionAction");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.httprequestcompressionaction.contenttypes", objid, "contentTypes","HTTPRequestCompressionAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"HTTPRequestCompressionAction");

  httpResponseCompressionAction = Util.getOptionalAttribute(objid, 'HTTPResponseCompressionAction', 'HTTPRequestCompressionAction');
  if httpResponseCompressionAction is not None and len(httpResponseCompressionAction) > 0:
    returndict = Util.createTypeFolder(respath, "HTTPResponseCompressionAction", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    httpResponseCompressionActionActionName = Util.getOptionalAttribute(httpResponseCompressionAction, "name", "HTTPResponseCompressionAction");
    if httpResponseCompressionActionActionName == None or len(httpResponseCompressionActionActionName) == 0:
      httpResponseCompressionActionActionName = ("HTTP Response Compression Action");
    Util.addAllFromExport(extraObjects, HTTPResponseCompressionAction._export(httpResponseCompressionAction, currespath, httpResponseCompressionActionActionName));

  httpRequestCompressionAction = Util.getOptionalAttribute(objid, 'HTTPRequestCompressionAction', 'HTTPRequestCompressionAction');
  if httpRequestCompressionAction is not None and len(httpRequestCompressionAction) > 0:
    returndict = Util.createTypeFolder(respath, "HTTPRequestCompressionAction", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    httpRequestCompressionActionName = Util.getOptionalAttribute(httpRequestCompressionAction, "name", "HTTPRequestCompressionAction");
    if httpRequestCompressionActionName == None or len(httpRequestCompressionActionName) == 0:
      httpRequestCompressionActionName = ("HTTP Request Compression Action")
    Util.addAllFromExport(extraObjects, _export(httpRequestCompressionAction, currespath, httpRequestCompressionActionName));

  headerAction = Util.getOptionalAttribute(objid, 'headerAction',"HTTPRequestCompressionAction");
  if headerAction is not None and len(headerAction) > 0:
    if headerAction.find("#HTTPRequestHeaderAction_") != -1:
      returndict = Util.createTypeFolder(respath, "HTTPRequestHeaderAction", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      httpRequestHeaderActionName = Util.getOptionalAttribute(headerAction, "name", "HTTPRequestHeaderAction");
      if httpRequestHeaderActionName == None or len(httpRequestHeaderActionName) == 0:
        httpRequestHeaderActionName = ("HTTP Request Header Action");
      Util.addAllFromExport(extraObjects, HTTPRequestHeaderAction._export(headerAction, currespath, httpRequestHeaderActionName));
    elif headerAction.find("#HTTPResponseHeaderAction_") != -1:
      returndict = Util.createTypeFolder(respath, "HTTPResponseHeaderAction", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      httpResponseHeaderActionName = Util.getOptionalAttribute(headerAction, "name", "HTTPResponseHeaderAction");
      if httpResponseHeaderActionName == None or len(httpResponseHeaderActionName) == 0:
        httpResponseHeaderActionName = ("HTTP Response Header Action");
      Util.addAllFromExport(extraObjects, HTTPResponseHeaderAction._export(headerAction, currespath, httpResponseHeaderActionName));

  httpCompressionAction = Util.getOptionalAttribute(objid, 'HTTPCompressionAction',"HTTPRequestCompressionAction");
  if httpCompressionAction is not None and len(httpCompressionAction) > 0:
    if httpCompressionAction.find("#HTTPRequestCompressionAction_") != -1:
      returndict = Util.createTypeFolder(respath, "HTTPRequestCompressionAction", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      httpCompressionActionName = Util.getOptionalAttribute(httpCompressionAction, "name", "HTTPRequestCompressionAction");
      if httpCompressionActionName == None or len(httpCompressionActionName) == 0:
        httpCompressionActionName = ("HTTP Request Compression Action");
      Util.addAllFromExport(extraObjects, _export(httpCompressionAction, currespath, httpCompressionActionName));
    elif httpCompressionAction.find("#HTTPResponseCompressionAction_") != -1:
      returndict = Util.createTypeFolder(respath, "HTTPResponseCompressionAction", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      httpCompressionActionName = Util.getOptionalAttribute(httpCompressionAction, "name", "HTTPResponseCompressionAction");
      if httpCompressionActionName == None or len(httpCompressionActionName) == 0:
        httpCompressionActionName = ("HTTP Response Compression Action");
      Util.addAllFromExport(extraObjects, HTTPResponseCompressionAction._export(httpCompressionAction, currespath, httpCompressionActionName));

  routingAction = Util.getOptionalAttribute(objid, 'routingAction', 'HTTPRequestCompressionAction');
  if routingAction is not None and len(routingAction) > 0:
    returndict = Util.createTypeFolder(respath, "RoutingAction", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    routingActionName = Util.getOptionalAttribute(routingAction, "name", "RoutingAction");
    if routingActionName == None or len(routingActionName) == 0:
      routingActionName = ("Routing Action")
    Util.addAllFromExport(extraObjects, RoutingAction._export(routingAction, currespath, routingActionName));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HTTPRequestCompressionAction');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('HTTPRequestCompressionAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPRequestCompressionAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.httprequestcompressionaction.name", None));
  Util.addIfNotNone(properties, "compressionType", roleProperties.optString("websphere.httprequestcompressionaction.compressiontype", None));
  Util.addPathProperty(properties, "contentTypes", roleProperties.optString("websphere.httprequestcompressionaction.contenttypes", None));
  print "Creating HTTPRequestCompressionAction with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HTTPRequestCompressionAction", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereHTTPRequestHeaderAction":
        HTTPRequestHeaderAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPResponseHeaderAction":
        HTTPResponseHeaderAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPRequestCompressionAction":
        create(objid, curjsonobject);
      elif currole == "WebSphereHTTPResponseCompressionAction":
        HTTPResponseCompressionAction.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('HTTPRequestCompressionAction');

def update(objid,jsonobject):
  Util.pushPathElement('HTTPRequestCompressionAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPRequestCompressionAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.httprequestcompressionaction.name", None), "name","HTTPRequestCompressionAction");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.httprequestcompressionaction.compressiontype", None), "compressionType","HTTPRequestCompressionAction");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.httprequestcompressionaction.contenttypes", None), "contentTypes","HTTPRequestCompressionAction");
  if len(atts) != 0:
    print "Modifying HTTPRequestCompressionAction with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HTTPRequestCompressionAction configuration up to date.";

  Property.removeProperties(objid, 'properties',"HTTPRequestCompressionAction");

  headerAction = Util.getOptionalAttribute(objid, 'headerAction', 'HTTPRequestCompressionAction');
  if headerAction is not None and len(headerAction) > 0:
    Util.remove(headerAction);

  httpCompressionAction = Util.getOptionalAttribute(objid, 'HTTPCompressionAction',"HTTPRequestCompressionAction");
  if httpCompressionAction is not None and len(httpCompressionAction) > 0:
    Util.remove(httpCompressionAction);

  routingAction = Util.getOptionalAttribute(objid, 'routingAction', 'HTTPRequestCompressionAction');
  if routingAction is not None and len(routingAction) > 0:
    Util.remove(routingAction);

  httpRequestCompressionAction = Util.getOptionalAttribute(objid, 'HttpResponseHeaderAction', 'HTTPRequestCompressionAction');
  if httpRequestCompressionAction is not None and len(httpRequestCompressionAction) > 0:
    Util.remove(httpRequestCompressionAction);

  httpResponseCompressionAction = Util.getOptionalAttribute(objid, 'HTTPResponseCompressionAction', 'HTTPRequestCompressionAction');
  if httpResponseCompressionAction is not None and len(httpResponseCompressionAction) > 0:
    Util.remove(httpResponseCompressionAction);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereHTTPRequestHeaderAction":
        HTTPRequestHeaderAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPResponseHeaderAction":
        HTTPResponseHeaderAction.create(objid, curjsonobject);
      elif currole == "WebSphereHTTPRequestCompressionAction":
        create(objid, curjsonobject);
      elif currole == "WebSphereHTTPResponseCompressionAction":
        HTTPResponseCompressionAction.create(objid, curjsonobject);
      elif currole == "WebSphereRoutingAction":
        RoutingAction.create(objid, curjsonobject);
      else:
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('HTTPRequestCompressionAction');
