from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = "websphere.httprequestcompressionactionref.name"

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HTTPRequestCompressionActionRef')

  if name == "":
    name = Util.getRequiredAttribute(objid, "name", "HTTPRequestCompressionAction");
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered HTTPRequestCompressionActionRef");
  exportedObject.put("roleName", "WebSphereHTTPRequestCompressionActionRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httprequestcompressionactionref.name", objid, "name","HTTPRequestCompressionAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HTTPRequestCompressionActionRef');
  return result;


def doImport(parentid, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WebSphereHTTPRequestCompressionActionRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.httprequestcompressionactionref.name"):
    raise Exception("Resource role properties does not contain websphere.httprequestcompressionactionref.name!");

  httpRequestCompressionActionRefName = roleProperties.optString("websphere.httprequestcompressionactionref.name", None);
  serverName = parentid.split('/servers/')[1].split('|')[0];
  if serverName == None or len(serverName) == 0:
    clusterName = parentid.split('/clusters/')[1].split('|')[0];
    containmentPath = "/ServerCluster:" + clusterName + "/ProxyVirtualHostConfig:/HTTPRequestCompressionAction:" + httpRequestCompressionActionRefName + "/";
  else:
    containmentPath = "/Server:" + serverName + "/ProxyVirtualHostConfig:/HTTPRequestCompressionAction:" + httpRequestCompressionActionRefName + "/";
  httpRequestCompressionAction = Util.getid(containmentPath);
  if httpRequestCompressionAction == None or len(httpRequestCompressionAction) == 0:
      raise Exception("Could not determine the HTTP Request Compression Action for HTTPRequestCompressionActionRef " + httpRequestCompressionActionRefName + ". Searched on containment path " + containmentPath + ".");

  Util.pushPathElement("Server");
  Util.pushPathElement("ProxyVirtualHostConfig");
  Util.pushPathElement("ProxyRuleExpression");
  Util.modify(parentid, [['enabledProxyActions', httpRequestCompressionAction]]);
  Util.popPathElement("ProxyRuleExpression");
  Util.popPathElement("ProxyVirtualHostConfig");
  Util.popPathElement("Server");
