from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HealthAction')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHealthAction");
  exportedObject.put("roleName", "WebSphereHealthAction");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.healthaction.actiontype", objid, "actionType","HealthAction");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.healthaction.stepnum", objid, "stepNum","HealthAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HealthAction');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('HealthAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("HealthAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "actionType", roleProperties.optString("websphere.healthaction.actiontype", None));
  Util.addIfNotNone(properties, "stepNum", roleProperties.optString("websphere.healthaction.stepnum", None));
  print "Creating HealthAction with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HealthAction", parentid, properties);
  Util.popPathElement('HealthAction');

def update(objid,jsonobject):
  Util.pushPathElement('HealthAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("HealthAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.healthaction.actiontype", None), "actionType","HealthAction");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.healthaction.stepnum", None), "stepNum","HealthAction");
  if len(atts) != 0:
    print "Modifying HealthAction with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HealthAction configuration up to date.";

  Util.popPathElement('HealthAction');

def getHealthActions(objid):
  healthActions = Util.getAssociatedObjects(objid, "HealthAction");
  return healthActions;
