from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.javavirtualmachinepreset.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'JavaVirtualMachinePreset');

  containmentpath = "%(parentconpath)sJavaVirtualMachinePreset:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('JavaVirtualMachinePreset')

  name = Util.getRequiredAttribute(objid, "name", 'JavaVirtualMachinePreset');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJavaVirtualMachinePreset");
  exportedObject.put("roleName", "WebSphereJavaVirtualMachinePreset");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.javavirtualmachinepreset.classpath", objid, "classpath","JavaVirtualMachinePreset");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachinepreset.name", objid, "name","JavaVirtualMachinePreset");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachinepreset.genericjvmarguments", objid, "genericJvmArguments","JavaVirtualMachinePreset");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachinepreset.maximumheapsize", objid, "maximumHeapSize","JavaVirtualMachinePreset");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javavirtualmachinepreset.initialheapsize", objid, "initialHeapSize","JavaVirtualMachinePreset");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.javavirtualmachinepreset.bootclasspath", objid, "bootClasspath","JavaVirtualMachinePreset");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"JavaVirtualMachinePreset");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JavaVirtualMachinePreset');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("JavaVirtualMachinePreset resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.javavirtualmachinepreset.name"):
    raise Exception("Resource role properties does not contain websphere.javavirtualmachinepreset.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create JavaVirtualMachinePreset on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('JavaVirtualMachinePreset')
  if not jsonobject.has("roleProperties"):
    raise Exception("JavaVirtualMachinePreset resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.javavirtualmachinepreset.name"):
    raise Exception("Resource role properties does not contain websphere.javavirtualmachinepreset.name!");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.javavirtualmachinepreset.classpath", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.javavirtualmachinepreset.name", None));
  Util.addIfNotNone(properties, "genericJvmArguments", roleProperties.optString("websphere.javavirtualmachinepreset.genericjvmarguments", None));
  Util.addIfNotNone(properties, "maximumHeapSize", roleProperties.optString("websphere.javavirtualmachinepreset.maximumheapsize", None));
  Util.addIfNotNone(properties, "initialHeapSize", roleProperties.optString("websphere.javavirtualmachinepreset.initialheapsize", None));
  Util.addPathProperty(properties, "bootClasspath", roleProperties.optString("websphere.javavirtualmachinepreset.bootclasspath", None));
  print "Creating JavaVirtualMachinePreset with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JavaVirtualMachinePreset", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('JavaVirtualMachinePreset');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('JavaVirtualMachinePreset')
  if not jsonobject.has("roleProperties"):
    raise Exception("JavaVirtualMachinePreset resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.javavirtualmachinepreset.name"):
    raise Exception("Resource role properties does not contain websphere.javavirtualmachinepreset.name!");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachinepreset.classpath", None), "classpath","JavaVirtualMachinePreset");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachinepreset.name", None), "name","JavaVirtualMachinePreset");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachinepreset.genericjvmarguments", None), "genericJvmArguments","JavaVirtualMachinePreset");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachinepreset.maximumheapsize", None), "maximumHeapSize","JavaVirtualMachinePreset");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachinepreset.initialheapsize", None), "initialHeapSize","JavaVirtualMachinePreset");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.javavirtualmachinepreset.bootclasspath", None), "bootClasspath","JavaVirtualMachinePreset");
  if len(atts) != 0:
    print "Modifying JavaVirtualMachinePreset with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JavaVirtualMachinePreset configuration up to date.";

  Property.removeProperties(objid, 'properties',"JavaVirtualMachinePreset");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('JavaVirtualMachinePreset');
