from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from File import File

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ReadOnlyDirectory')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereReadOnlyDirectory");
  exportedObject.put("roleName", "WebSphereReadOnlyDirectory");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.readonlydirectory.directoryentry", objid, "directoryEntry","ReadOnlyDirectory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.readonlydirectory.uri", objid, "URI","ReadOnlyDirectory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.readonlydirectory.size", objid, "size","ReadOnlyDirectory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.readonlydirectory.lastmodified", objid, "lastModified","ReadOnlyDirectory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.readonlydirectory.originaluri", objid, "originalURI","ReadOnlyDirectory");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = File.exportFiles(objid, respath, extraObjects, typeFolders, 'files', "ReadOnlyDirectory");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ReadOnlyDirectory');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ReadOnlyDirectory')
  if not jsonobject.has("roleProperties"):
    raise Exception("ReadOnlyDirectory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "directoryEntry", roleProperties.optString("websphere.readonlydirectory.directoryentry", None));
  Util.addIfNotNone(properties, "URI", roleProperties.optString("websphere.readonlydirectory.uri", None));
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.readonlydirectory.size", None));
  Util.addIfNotNone(properties, "lastModified", roleProperties.optString("websphere.readonlydirectory.lastmodified", None));
  Util.addIfNotNone(properties, "originalURI", roleProperties.optString("websphere.readonlydirectory.originaluri", None));
  print "Creating ReadOnlyDirectory with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ReadOnlyDirectory", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ReadOnlyDirectory');

def update(objid,jsonobject):
  Util.pushPathElement('ReadOnlyDirectory')
  if not jsonobject.has("roleProperties"):
    raise Exception("ReadOnlyDirectory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.readonlydirectory.directoryentry", None), "directoryEntry","ReadOnlyDirectory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.readonlydirectory.uri", None), "URI","ReadOnlyDirectory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.readonlydirectory.size", None), "size","ReadOnlyDirectory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.readonlydirectory.lastmodified", None), "lastModified","ReadOnlyDirectory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.readonlydirectory.originaluri", None), "originalURI","ReadOnlyDirectory");
  if len(atts) != 0:
    print "Modifying ReadOnlyDirectory with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ReadOnlyDirectory configuration up to date.";

  File.removeFiles(objid, 'files',"ReadOnlyDirectory");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ReadOnlyDirectory');
