from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RemoteCellAccessPoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRemoteCellAccessPoint");
  exportedObject.put("roleName", "WebSphereRemoteCellAccessPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.remotecellaccesspoint.cellname", objid, "cellName","RemoteCellAccessPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"RemoteCellAccessPoint");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RemoteCellAccessPoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('RemoteCellAccessPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("RemoteCellAccessPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "cellName", roleProperties.optString("websphere.remotecellaccesspoint.cellname", None));
  print "Creating RemoteCellAccessPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("RemoteCellAccessPoint", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('RemoteCellAccessPoint');

def update(objid,jsonobject):
  Util.pushPathElement('RemoteCellAccessPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("RemoteCellAccessPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.remotecellaccesspoint.cellname", None), "cellName","RemoteCellAccessPoint");
  if len(atts) != 0:
    print "Modifying RemoteCellAccessPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "RemoteCellAccessPoint configuration up to date.";

  Property.removeProperties(objid, 'properties',"RemoteCellAccessPoint");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('RemoteCellAccessPoint');
