from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSEndpointListener')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSEndpointListener");
  exportedObject.put("roleName", "WebSphereSIBWSEndpointListener");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsendpointlistener.name", objid, "name","SIBWSEndpointListener");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsendpointlistener.description", objid, "description","SIBWSEndpointListener");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsendpointlistener.wsdlservinghttpurlroot", objid, "WSDLServingHTTPURLRoot","SIBWSEndpointListener");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsendpointlistener.urlroot", objid, "URLRoot","SIBWSEndpointListener");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSEndpointListener');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSEndpointListener')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSEndpointListener resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibwsendpointlistener.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibwsendpointlistener.description", None));
  Util.addIfNotNone(properties, "WSDLServingHTTPURLRoot", roleProperties.optString("websphere.sibwsendpointlistener.wsdlservinghttpurlroot", None));
  Util.addIfNotNone(properties, "URLRoot", roleProperties.optString("websphere.sibwsendpointlistener.urlroot", None));
  print "Creating SIBWSEndpointListener with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSEndpointListener", parentid, properties);
  Util.popPathElement('SIBWSEndpointListener');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSEndpointListener')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSEndpointListener resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsendpointlistener.name", None), "name","SIBWSEndpointListener");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsendpointlistener.description", None), "description","SIBWSEndpointListener");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsendpointlistener.wsdlservinghttpurlroot", None), "WSDLServingHTTPURLRoot","SIBWSEndpointListener");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsendpointlistener.urlroot", None), "URLRoot","SIBWSEndpointListener");
  if len(atts) != 0:
    print "Modifying SIBWSEndpointListener with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSEndpointListener configuration up to date.";

  Util.popPathElement('SIBWSEndpointListener');
