from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from ThreadPool import ThreadPool
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ThreadPoolManager')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereThreadPoolManager");
  exportedObject.put("roleName", "WebSphereThreadPoolManager");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.threadpoolmanager.enable", objid, "enable","ThreadPoolManager");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ThreadPoolManager");

  threadPools = Util.parseConfigIdListAttribute(objid, 'threadPools',"ThreadPoolManager");
  for threadPool in threadPools:
    if len(threadPool) > 0:
      returndict = Util.createTypeFolder(respath, "ThreadPool", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ThreadPool._export(threadPool, currespath));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ThreadPoolManager');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ThreadPoolManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("ThreadPoolManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.threadpoolmanager.enable", None));
  print "Creating ThreadPoolManager with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ThreadPoolManager", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereThreadPool":
          ThreadPool.create(objid, curjsonobject);
  Util.popPathElement('ThreadPoolManager');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ThreadPoolManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("ThreadPoolManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.threadpoolmanager.enable", None), "enable","ThreadPoolManager");
  if len(atts) != 0:
    print "Modifying ThreadPoolManager with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ThreadPoolManager configuration up to date.";

  Property.removeProperties(objid, 'properties',"ThreadPoolManager");

  threadPools = Util.parseConfigIdListAttribute(objid, 'threadPools',"ThreadPoolManaager");
  for threadPool in threadPools:
    if len(threadPool) > 0:
      Util.remove(threadPool);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereThreadPool":
          ThreadPool.create(objid, curjsonobject);
  Util.popPathElement('ThreadPoolManager');
