from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSGWTargetService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSGWTargetService");
  exportedObject.put("roleName", "WebSphereWSGWTargetService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwtargetservice.targetdestinationname", objid, "targetDestinationName","WSGWTargetService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwtargetservice.outboundservicename", objid, "outboundServiceName","WSGWTargetService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwtargetservice.name", objid, "name","WSGWTargetService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwtargetservice.description", objid, "description","WSGWTargetService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwtargetservice.busname", objid, "busName","WSGWTargetService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwtargetservice.targetserviceidentity", objid, "targetServiceIdentity","WSGWTargetService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSGWTargetService');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSGWTargetService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSGWTargetService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "targetDestinationName", roleProperties.optString("websphere.wsgwtargetservice.targetdestinationname", None));
  Util.addIfNotNone(properties, "outboundServiceName", roleProperties.optString("websphere.wsgwtargetservice.outboundservicename", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wsgwtargetservice.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.wsgwtargetservice.description", None));
  Util.addIfNotNone(properties, "busName", roleProperties.optString("websphere.wsgwtargetservice.busname", None));
  Util.addIfNotNone(properties, "targetServiceIdentity", roleProperties.optString("websphere.wsgwtargetservice.targetserviceidentity", None));
  print "Creating WSGWTargetService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSGWTargetService", parentid, properties);
  Util.popPathElement('WSGWTargetService');

def update(objid,jsonobject):
  Util.pushPathElement('WSGWTargetService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSGWTargetService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwtargetservice.targetdestinationname", None), "targetDestinationName","WSGWTargetService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwtargetservice.outboundservicename", None), "outboundServiceName","WSGWTargetService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwtargetservice.name", None), "name","WSGWTargetService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwtargetservice.description", None), "description","WSGWTargetService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwtargetservice.busname", None), "busName","WSGWTargetService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwtargetservice.targetserviceidentity", None), "targetServiceIdentity","WSGWTargetService");
  if len(atts) != 0:
    print "Modifying WSGWTargetService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSGWTargetService configuration up to date.";

  Util.popPathElement('WSGWTargetService');
