from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ApplicationProfileService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereApplicationProfileService");
  exportedObject.put("roleName", "WebSphereApplicationProfileService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationprofileservice.compatibility", objid, "compatibility","ApplicationProfileService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationprofileservice.enable", objid, "enable","ApplicationProfileService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ApplicationProfileService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ApplicationProfileService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ApplicationProfileService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationProfileService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "compatibility", roleProperties.optString("websphere.applicationprofileservice.compatibility", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.applicationprofileservice.enable", None));
  print "Creating ApplicationProfileService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ApplicationProfileService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ApplicationProfileService');


def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ApplicationProfileService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationProfileService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationprofileservice.compatibility", None), "compatibility","ApplicationProfileService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationprofileservice.enable", None), "enable","ApplicationProfileService");
  if len(atts) != 0:
    print "Modifying ApplicationProfileService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ApplicationProfileService configuration up to date.";

  Property.removeProperties(objid, 'properties',"ApplicationProfileService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ApplicationProfileService');
