from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  name = "ExecutionTimeAndThreadLimit";

  containmentpath = "%(parentconpath)sExecutionTimeAndThreadLimit:/" % {'parentconpath':parentcontainmentpath}
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict


def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ExecutionTimeAndThreadLimit')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereExecutionTimeAndThreadLimit");
  exportedObject.put("roleName", "WebSphereExecutionTimeAndThreadLimit");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.executiontimeandthreadlimit.maxconcurrentjob", objid, "maxConcurrentJob","ExecutionTimeAndThreadLimit");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.executiontimeandthreadlimit.maxexecutiontime", objid, "maxExecutionTime","ExecutionTimeAndThreadLimit");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ExecutionTimeAndThreadLimit');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("ExecutionTimeAndThreadLimit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  
  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create ExecutionTimeAndThreadLimit on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;

def create(parentid, jsonobject):
  Util.pushPathElement('ExecutionTimeAndThreadLimit')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExecutionTimeAndThreadLimit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maxConcurrentJob", roleProperties.optString("websphere.executiontimeandthreadlimit.maxconcurrentjob", None));
  Util.addIfNotNone(properties, "maxExecutionTime", roleProperties.optString("websphere.executiontimeandthreadlimit.maxexecutiontime", None));
  print "Creating ExecutionTimeAndThreadLimit with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ExecutionTimeAndThreadLimit", parentid, properties);
  Util.popPathElement('ExecutionTimeAndThreadLimit');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ExecutionTimeAndThreadLimit')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExecutionTimeAndThreadLimit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.executiontimeandthreadlimit.maxconcurrentjob", None), "maxConcurrentJob","ExecutionTimeAndThreadLimit");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.executiontimeandthreadlimit.maxexecutiontime", None), "maxExecutionTime","ExecutionTimeAndThreadLimit");
  if len(atts) != 0:
    print "Modifying ExecutionTimeAndThreadLimit with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ExecutionTimeAndThreadLimit configuration up to date.";

  Util.popPathElement('ExecutionTimeAndThreadLimit');
