from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from GSCMember import GSCMember
__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GenericServerClusterMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGenericServerClusterMapping");
  exportedObject.put("roleName", "WebSphereGenericServerClusterMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericserverclustermapping.clustername", objid, "clusterName","GenericServerClusterMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  gscMembers = Util.parseConfigIdListAttribute(objid, 'gscMembers',"GenericServerClusterMapping");
  for gscMember in gscMembers:
    if gscMember is not None and len(gscMember) > 0:
      returndict = Util.createTypeFolder(respath, "GSCMember", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, GSCMember._export(gscMember, currespath, "GSC Member%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GenericServerClusterMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GenericServerClusterMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericServerClusterMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "clusterName", roleProperties.optString("websphere.genericserverclustermapping.clustername", None));
  print "Creating GenericServerClusterMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GenericServerClusterMapping", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereGSCMember":
        GSCMember.create(objid, curjsonobject);
  Util.popPathElement('GenericServerClusterMapping');

def update(objid,jsonobject):
  Util.pushPathElement('GenericServerClusterMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericServerClusterMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericserverclustermapping.clustername", None), "clusterName","GenericServerClusterMapping");
  if len(atts) != 0:
    print "Modifying GenericServerClusterMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GenericServerClusterMapping configuration up to date.";

  gscMembers = Util.parseConfigIdListAttribute(objid, 'gscMembers',"GenericServerClusterMapping");
  for gscMember in gscMembers:
    if len(gscMember) > 0:
      Util.remove(gscMembers);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereGSCMember":
        GSCMember.create(objid, curjsonobject);

  Util.popPathElement('GenericServerClusterMapping');
