from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.corbaobjectnamespacebinding.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'CORBAObjectNameSpaceBinding');

  containmentpath = "%(parentconpath)sCORBAObjectNameSpaceBinding:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('CORBAObjectNameSpaceBinding')

  name = Util.getRequiredAttribute(objid, "name", 'CORBAObjectNameSpaceBinding');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCORBAObjectNameSpaceBinding");
  exportedObject.put("roleName", "WebSphereCORBAObjectNameSpaceBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.corbaobjectnamespacebinding.corbanameurl", objid, "corbanameUrl","CORBAObjectNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.corbaobjectnamespacebinding.name", objid, "name","CORBAObjectNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.corbaobjectnamespacebinding.nameinnamespace", objid, "nameInNameSpace","CORBAObjectNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.corbaobjectnamespacebinding.federatedcontext", objid, "federatedContext","CORBAObjectNameSpaceBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CORBAObjectNameSpaceBinding');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("CORBAObjectNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.corbaobjectnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.corbaobjectnamespacebinding.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      if parentid == None or len(parentid) == 0:
        raise Exception("Parent does not exist to create CORBAObjectNameSpaceBinding on.");
      objid = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(objid);
      objid = None;
    else:
      update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('CORBAObjectNameSpaceBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("CORBAObjectNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.corbaobjectnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.corbaobjectnamespacebinding.name!");

  properties = [];
  Util.addIfNotNone(properties, "corbanameUrl", roleProperties.optString("websphere.corbaobjectnamespacebinding.corbanameurl", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.corbaobjectnamespacebinding.name", None));
  Util.addIfNotNone(properties, "nameInNameSpace", roleProperties.optString("websphere.corbaobjectnamespacebinding.nameinnamespace", None));
  Util.addIfNotNone(properties, "federatedContext", roleProperties.optString("websphere.corbaobjectnamespacebinding.federatedcontext", None));
  print "Creating CORBAObjectNameSpaceBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CORBAObjectNameSpaceBinding", parentid, properties);
  Util.popPathElement('CORBAObjectNameSpaceBinding');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('CORBAObjectNameSpaceBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("CORBAObjectNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.corbaobjectnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.corbaobjectnamespacebinding.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.corbaobjectnamespacebinding.corbanameurl", None), "corbanameUrl","CORBAObjectNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.corbaobjectnamespacebinding.name", None), "name","CORBAObjectNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.corbaobjectnamespacebinding.nameinnamespace", None), "nameInNameSpace","CORBAObjectNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.corbaobjectnamespacebinding.federatedcontext", None), "federatedContext","CORBAObjectNameSpaceBinding");
  if len(atts) != 0:
    print "Modifying CORBAObjectNameSpaceBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CORBAObjectNameSpaceBinding configuration up to date.";

  Util.popPathElement('CORBAObjectNameSpaceBinding');
